/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.cli;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.cli.OptionHandler;
import de.qtc.beanshooter.cli.SASLMechanism;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanOperation;
import de.qtc.beanshooter.operation.BeanshooterOperation;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;

public class ArgumentHandler {
    private Namespace args;
    private ArgumentParser parser = ArgumentParsers.newFor("beanshooter").build();
    private Properties config;
    private Operation action = null;
    private static ArgumentHandler instance = null;
    private static final String defaultConfiguration = "/config.properties";

    public ArgumentHandler(String[] argv) {
        this.parser.description("beanshooter v" + ArgumentHandler.class.getPackage().getImplementationVersion() + " - a JMX enumeration and attacking tool");
        Subparsers subparsers = this.parser.addSubparsers().help(" ").metavar(" ").dest("action");
        BeanshooterOperation.addSubparsers(subparsers);
        MBeanOperation.addSubparsers(subparsers);
        try {
            this.args = this.parser.parseArgs(argv);
        }
        catch (ArgumentParserException e) {
            this.parser.handleError(e);
            System.exit(1);
        }
        this.initialize();
        if (instance == null) {
            instance = this;
        }
    }

    private void initialize() {
        this.config = this.loadConfig((String)this.args.get(BeanshooterOption.GLOBAL_CONFIG.name()));
        OptionHandler.prepareOptions(this.args, this.config);
        if (BeanshooterOption.GLOBAL_NO_COLOR.getBool()) {
            Logger.disableColor();
        }
        PluginSystem.init((String)BeanshooterOption.GLOBAL_PLUGIN.getValue());
    }

    private Properties loadConfig(String filename) {
        Properties config = new Properties();
        try {
            InputStream configStream = null;
            configStream = ArgumentParser.class.getResourceAsStream(defaultConfiguration);
            config.load(configStream);
            configStream.close();
            if (filename != null) {
                configStream = new FileInputStream(filename);
                config.load(configStream);
                configStream.close();
            }
        }
        catch (IOException e) {
            ExceptionHandler.unexpectedException(e, "loading", ".properties file", true);
        }
        return config;
    }

    public String getFromConfig(String property) {
        return (String)this.config.get(property);
    }

    public Operation getAction() {
        String actionArg = this.args.getString("action");
        this.action = BeanshooterOperation.getByName(actionArg);
        if (this.action == null) {
            MBean selectedBean = MBean.getMBean(actionArg);
            if (selectedBean == null) {
                ExceptionHandler.internalError("ArgumentHandler.getAction", "Unable to find MBean with name: " + selectedBean);
            }
            MBeanOperation.setMBean(selectedBean);
            String mBeanAction = this.args.getString("mbean-action");
            this.action = MBeanOperation.getByName(mBeanAction);
        }
        if (this.action == null) {
            ExceptionHandler.internalError("ArgumentHandler.getAction", "The specified action is not avaialble");
        }
        return this.action;
    }

    public Object getGadget() {
        String gadget = (String)ArgumentHandler.require(BeanshooterOption.SERIAL_GADGET_NAME);
        String command = (String)ArgumentHandler.require(BeanshooterOption.SERIAL_GADGET_CMD);
        return PluginSystem.getPayloadObject(this.getAction(), gadget, command);
    }

    public static ArgumentHandler getInstance() {
        return instance;
    }

    public static SASLMechanism getSASLMechanism() {
        if (BeanshooterOption.CONN_SASL.isNull()) {
            return null;
        }
        String mechanism = (String)BeanshooterOption.CONN_SASL.getValue();
        return SASLMechanism.valueOf(mechanism.toUpperCase());
    }

    public static <T> T require(Option option) {
        if (option.notNull()) {
            try {
                return option.getValue();
            }
            catch (ClassCastException e) {
                ExceptionHandler.internalError("RMGOption.require", "Caught class cast exception.");
            }
        }
        Logger.resetIndent();
        Logger.eprintlnMixedYellow("Error: The specified aciton requires the", option.getName(), "option.");
        Utils.exit();
        return null;
    }

    public static Object requireOneOf(Option ... options) {
        StringBuilder helpString = new StringBuilder();
        for (Option option : options) {
            if (option.notNull()) {
                return option.getValue();
            }
            helpString.append(option.getName());
            helpString.append(", ");
        }
        helpString.setLength(helpString.length() - 2);
        Logger.resetIndent();
        Logger.eprintlnMixedYellow("Error: The specified aciton requires one of the", helpString.toString(), "options.");
        Utils.exit();
        return null;
    }

    public static void requireAllOf(Option ... options) {
        boolean failed = false;
        StringBuilder helpString = new StringBuilder();
        for (Option option : options) {
            if (option.isNull()) {
                failed = true;
            }
            helpString.append(option.getName());
            helpString.append(", ");
        }
        helpString.setLength(helpString.length() - 2);
        if (failed) {
            Logger.resetIndent();
            Logger.eprintlnMixedYellow("Error: The specified aciton requires the", helpString.toString(), "options.");
            Utils.exit();
        }
    }

    public static Map<String, Object> getEnv() {
        return PluginSystem.getEnv((String)BeanshooterOption.CONN_USER.getValue(), (String)BeanshooterOption.CONN_PASS.getValue());
    }
}

