/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.cli;

import de.qtc.beanshooter.cli.Operation;
import java.util.HashMap;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;

public enum OptionGroup {
    BEAN("MBean options"),
    TARGET("target arguments"),
    CONNECTION("connection arguments"),
    ACTION("action arguments"),
    GENERAL("general arguments"),
    NONE("");

    private final String name;
    private final HashMap<Pair, ArgumentGroup> argumentGroups;

    private OptionGroup(String name) {
        this.name = name;
        this.argumentGroups = new HashMap();
    }

    public ArgumentGroup addArgumentGroup(ArgumentParser argParser, Operation operation) {
        Pair pair = new Pair(argParser, operation);
        ArgumentGroup group = this.argumentGroups.get(pair);
        if (group == null) {
            group = argParser.addArgumentGroup(this.name);
            this.argumentGroups.put(pair, group);
        }
        return group;
    }

    class Pair {
        private ArgumentParser parser;
        private Operation operation;

        Pair(ArgumentParser parser, Operation operation) {
            this.parser = parser;
            this.operation = operation;
        }

        public int hashCode() {
            return Objects.hash(this.parser, this.operation);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            return other.parser == this.parser && other.operation == this.operation;
        }
    }
}

