/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.cli;

import de.qtc.beanshooter.cli.ArgType;
import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.cli.OptionGroup;
import de.qtc.beanshooter.cli.SASLMechanism;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.mlet.MLetOption;
import de.qtc.beanshooter.mbean.tomcat.MemoryUserDatabaseMBeanOption;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanOption;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;

public class OptionHandler {
    private static Option[] options;

    public static void prepareOptions(Namespace args, Properties config) {
        for (Option option : options) {
            Object defaultValue = config.getProperty(option.name().toLowerCase());
            try {
                if (defaultValue != null && !((String)defaultValue).isEmpty()) {
                    if (option.getArgType() == ArgType.INT) {
                        defaultValue = Integer.valueOf((String)defaultValue);
                    } else if (option.getArgType() == ArgType.BOOL) {
                        defaultValue = Boolean.valueOf((String)defaultValue);
                    }
                } else if (defaultValue != null && ((String)defaultValue).isEmpty()) {
                    defaultValue = null;
                }
            }
            catch (Exception e) {
                Logger.eprintlnMixedYellow("RMGOption", option.getName(), "obtained an invalid argument.");
                Utils.exit(e);
            }
            option.setValue(args, defaultValue);
        }
    }

    public static void addOptions(Operation operation, ArgumentParser argParser) {
        for (Option option : options) {
            Argument arg;
            if (!operation.containsOption(option)) continue;
            OptionGroup group = option.optionGroup();
            if (group == OptionGroup.NONE || group == OptionGroup.ACTION) {
                arg = argParser.addArgument(option.getName()).help(option.description()).action(option.argumentAction());
            } else {
                ArgumentGroup arggroup = group.addArgumentGroup(argParser, operation);
                arg = arggroup.addArgument(option.getName()).help(option.description()).action(option.argumentAction());
            }
            OptionHandler.addModifiers(option, arg);
        }
    }

    public static void addModifiers(Option option, Argument arg) {
        if (option.metavar() != null) {
            arg.metavar(option.metavar());
        }
        if (option.getArgType() == ArgType.INT) {
            arg.type(Integer.class);
        }
        if (option == BeanshooterOption.CONN_SASL) {
            arg.choices(SASLMechanism.getMechanisms());
        }
        if (option == BeanshooterOption.INVOKE_METHOD_ARGS) {
            arg.nargs("*");
        }
        if (option == TonkaBeanOption.EXEC_ARRAY) {
            arg.nargs("+");
        }
        if (option == BeanshooterOption.STANDARD_OPERATION_ARGS) {
            arg.nargs("?");
            arg.setDefault("");
        }
        if (option == TonkaBeanOption.DOWNLOAD_DEST) {
            arg.nargs("?");
        }
        if (option == TonkaBeanOption.UPLOAD_DEST) {
            arg.nargs("?");
        }
        if (option == BeanshooterOption.ATTR_VALUE) {
            arg.nargs("?");
        }
        if (option == BeanshooterOption.MODEL_RESOURCE) {
            arg.nargs("?");
        }
        if (option == BeanshooterOption.OBJ_NAME) {
            arg.nargs("?");
        }
        if (option == BeanshooterOption.ATTR_VALUE) {
            arg.nargs("?");
        }
        if (option == MemoryUserDatabaseMBeanOption.PASS_FILE) {
            arg.nargs("?");
        }
        if (option == MLetOption.LOAD_BEAN) {
            List<String> mBeanNames = MBean.getLoadableBeanNames();
            mBeanNames.add("custom");
            arg.choices(mBeanNames);
        }
        if (option == BeanshooterOption.STANDARD_OPERATION) {
            arg.choices("exec", "upload", "tonka");
        }
    }

    static {
        ArrayList<Option> opts = new ArrayList<Option>();
        opts.addAll(Arrays.asList(BeanshooterOption.values()));
        for (MBean bean : MBean.values()) {
            opts.addAll(Arrays.asList(bean.getOptions()));
        }
        options = opts.toArray(new Option[0]);
    }
}

