/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.cli;

import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.MismatchedURIException;
import de.qtc.beanshooter.exceptions.SaslProfileException;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.PluginSystem;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jolokia.client.exception.J4pRemoteException;

public enum SASLMechanism {
    PLAIN("SASL/PLAIN"),
    DIGEST("SASL/DIGEST-MD5"),
    CRAM("SASL/CRAM-MD5"),
    GSSAPI("SASL/GSSAPI"),
    NTLM("SASL/NTLM");

    private String profile;
    private String extra;

    private SASLMechanism(String profile) {
        this.profile = profile;
    }

    public String getProfile() {
        String profile = "";
        if (BeanshooterOption.CONN_SSL.getBool()) {
            profile = "TLS ";
        }
        return profile + this.profile;
    }

    public String getExtra() {
        return this.extra;
    }

    public void init(Map<String, Object> env, String username, String password) {
        this.setJmxProfile(env);
        this.setCallbackHandler(env, username, password);
    }

    public void setCallbackHandler(Map<String, Object> env, String username, String password) {
        if (this == DIGEST || this == NTLM) {
            env.put("jmx.remote.sasl.callback.handler", new RealmHandler(username, password));
        }
    }

    public void setJmxProfile(Map<String, Object> env) {
        env.put("jmx.remote.profiles", this.getProfile());
    }

    public static String[] getMechanisms() {
        int ctr = 0;
        String[] mechanisms = new String[5];
        for (SASLMechanism mechanism : SASLMechanism.values()) {
            mechanisms[ctr] = mechanism.name().toLowerCase();
            ++ctr;
        }
        return mechanisms;
    }

    public static SASLMechanism detectMechanis(String host, int port, Map<String, Object> env) {
        for (SASLMechanism mechanism : SASLMechanism.values()) {
            BeanshooterOption.CONN_SASL.setValue(mechanism.name().toLowerCase());
            try {
                PluginSystem.getMBeanServerConnectionUmanaged(host, port, env);
                return mechanism;
            }
            catch (SaslProfileException e) {
                ExceptionHandler.showStackTrace(e);
            }
            catch (AuthenticationException e) {
                if (mechanism == DIGEST && e instanceof MismatchedURIException) {
                    mechanism.extra = ((MismatchedURIException)e).getUri();
                }
                return mechanism;
            }
            catch (J4pRemoteException e) {
                ExceptionHandler.handleJ4pRemoteException(e, "during SASL negotiation");
            }
        }
        return null;
    }

    class RealmHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        RealmHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nameCallback = null;
            RealmCallback realmCallback = null;
            PasswordCallback passwordCallback = null;
            RealmChoiceCallback realmChoiceCallback = null;
            String realm = "";
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    nameCallback = (NameCallback)callbacks[i];
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    passwordCallback = (PasswordCallback)callbacks[i];
                    passwordCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callbacks[i] instanceof RealmCallback) {
                    realmCallback = (RealmCallback)callbacks[i];
                    realm = realmCallback.getDefaultText();
                    realmCallback.setText(realm);
                    continue;
                }
                if (callbacks[i] instanceof RealmChoiceCallback) {
                    realmChoiceCallback = (RealmChoiceCallback)callbacks[i];
                    realmChoiceCallback.setSelectedIndex(realmChoiceCallback.getDefaultChoice());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }
}

