/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.io;

import de.qtc.beanshooter.operation.BeanshooterOption;

public class Logger {
    private static String ANSI_RESET = "\u001b[0m";
    private static String ANSI_YELLOW = "\u001b[33m";
    private static String ANSI_BLUE = "\u001b[34m";
    private static String ANSI_RED = "\u001b[31m";
    private static String ANSI_GREEN = "\u001b[32m";
    private static String ANSI_PURPLE = "\u001b[35m";
    public static int indent = 0;
    public static int printCount = 0;
    public static boolean stdout = true;
    public static boolean stderr = true;

    public static void disable() {
        stdout = false;
        stderr = false;
    }

    public static void disableStdout() {
        stdout = false;
    }

    public static void disableStderr() {
        stderr = false;
    }

    public static void disableIfNotVerbose() {
        if (!BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
            Logger.disable();
        }
    }

    public static void enable() {
        stdout = true;
        stderr = true;
    }

    public static void enableStdout() {
        stdout = true;
    }

    public static void enableStderr() {
        stderr = true;
    }

    public static String blue(String msg) {
        return ANSI_BLUE + msg + ANSI_RESET;
    }

    public static String yellow(String msg) {
        return ANSI_YELLOW + msg + ANSI_RESET;
    }

    public static String red(String msg) {
        return ANSI_RED + msg + ANSI_RESET;
    }

    public static String purple(String msg) {
        return ANSI_PURPLE + msg + ANSI_RESET;
    }

    public static String green(String msg) {
        return ANSI_GREEN + msg + ANSI_RESET;
    }

    private static String prefix() {
        ++printCount;
        return "[+]" + Logger.getIndent();
    }

    private static String eprefix() {
        ++printCount;
        return "[-]" + Logger.getIndent();
    }

    private static void log(String msg) {
        Logger.log(msg, true);
    }

    private static void log(String msg, boolean newline) {
        if (stdout) {
            if (newline) {
                System.out.println(msg);
            } else {
                System.out.print(msg);
            }
        }
    }

    private static void elog(String msg) {
        Logger.elog(msg, true);
    }

    private static void elog(String msg, boolean newline) {
        if (stderr) {
            if (newline) {
                System.err.println(msg);
            } else {
                System.err.print(msg);
            }
        }
    }

    public static void lineBreak() {
        if (printCount != 0) {
            ++printCount;
            Logger.log("[+]", true);
        }
    }

    public static void print(String msg) {
        Logger.log(Logger.prefix() + msg, false);
    }

    public static void printPlain(String msg) {
        Logger.log(msg, false);
    }

    public static void println(String msg) {
        Logger.log(Logger.prefix() + msg);
    }

    public static void printlnPlain(String msg) {
        Logger.log(msg, true);
    }

    public static void eprint(String msg) {
        Logger.elog(Logger.eprefix() + msg, false);
    }

    public static void eprintln(String msg) {
        Logger.elog(Logger.eprefix() + msg);
    }

    public static void eprintlnPlain(String msg) {
        Logger.elog(msg);
    }

    public static void printlnBlue(String msg) {
        Logger.log(Logger.prefix() + Logger.blue(msg));
    }

    public static void printlnRed(String msg) {
        Logger.log(Logger.prefix() + Logger.red(msg));
    }

    public static void eprintlnBlue(String msg) {
        Logger.elog(Logger.eprefix() + Logger.blue(msg));
    }

    public static void printlnYellow(String msg) {
        Logger.log(Logger.prefix() + Logger.yellow(msg));
    }

    public static void eprintlnYellow(String msg) {
        Logger.elog(Logger.eprefix() + Logger.yellow(msg));
    }

    public static void printlnPlainBlue(String msg) {
        Logger.log(Logger.blue(msg));
    }

    public static void printPlainBlue(String msg) {
        Logger.log(Logger.blue(msg), false);
    }

    public static void printBlue(String msg) {
        Logger.log(Logger.prefix() + Logger.blue(msg), false);
    }

    public static void printPlainGreen(String msg) {
        Logger.log(Logger.green(msg), false);
    }

    public static void printPlainRed(String msg) {
        Logger.log(Logger.red(msg), false);
    }

    public static void printlnPlainGreen(String msg) {
        Logger.log(Logger.green(msg), true);
    }

    public static void eprintlnPlainBlue(String msg) {
        Logger.elog(Logger.blue(msg));
    }

    public static void printlnPlainYellow(String msg) {
        Logger.log(Logger.yellow(msg));
    }

    public static void printPlainYellow(String msg) {
        Logger.log(Logger.yellow(msg), false);
    }

    public static void eprintlnPlainYellow(String msg) {
        Logger.elog(Logger.yellow(msg));
    }

    public static void printMixedRed(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.red(second), false);
    }

    public static void printMixedRed(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.red(second) + " " + third, false);
    }

    public static void printlnMixedRed(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.red(second));
    }

    public static void printlnMixedRed(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.red(second) + " " + third);
    }

    public static void printlnPlainMixedRed(String first, String second) {
        Logger.log(first + " " + Logger.red(second));
    }

    public static void printPlainMixedRed(String first, String second) {
        Logger.log(first + " " + Logger.red(second), false);
    }

    public static void printlnMixedGreen(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.green(second));
    }

    public static void printlnPlainMixedGreen(String first, String second) {
        Logger.log(first + " " + Logger.green(second));
    }

    public static void printPlainMixedGreen(String first, String second) {
        Logger.log(first + " " + Logger.green(second), false);
    }

    public static void printlnMixedPurple(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.purple(second));
    }

    public static void printlnPlainMixedPurple(String first, String second) {
        Logger.log(first + " " + Logger.purple(second));
    }

    public static void printPlainMixedPurple(String first, String second) {
        Logger.log(first + " " + Logger.purple(second), false);
    }

    public static void printlnMixedBlue(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.blue(second));
    }

    public static void printlnMixedBlue(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.blue(second) + " " + third);
    }

    public static void printlnMixedBlueYellow(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second + " " + Logger.yellow(third));
    }

    public static void printlnMixedBlueRed(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second + " " + Logger.red(third));
    }

    public static void printlnMixedYellow(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.yellow(second));
    }

    public static void printlnMixedYellow(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.yellow(second) + " " + third);
    }

    public static void printPlainMixedYellow(String first, String second) {
        Logger.log(first + " " + Logger.yellow(second), false);
    }

    public static void printlnPlainMixedYellow(String first, String second) {
        Logger.log(first + " " + Logger.yellow(second));
    }

    public static void eprintlnPlainMixedYellow(String first, String second) {
        Logger.elog(first + " " + Logger.yellow(second));
    }

    public static void printlnPlainMixedYellow(String first, String second, String third) {
        Logger.log(first + " " + Logger.yellow(second) + " " + third);
    }

    public static void eprintlnPlainMixedYellow(String first, String second, String third) {
        Logger.elog(first + " " + Logger.yellow(second) + " " + third);
    }

    public static void printPlainMixedYellowFirst(String first, String second) {
        Logger.log(Logger.yellow(first) + " " + second, false);
    }

    public static void printPlainMixedYellowFirst(String first, String second, String third) {
        Logger.log(Logger.yellow(first) + " " + second + " " + Logger.yellow(third), false);
    }

    public static void printlnPlainMixedYellowFirst(String first, String second) {
        Logger.log(Logger.yellow(first) + " " + second);
    }

    public static void eprintlnPlainMixedYellowFirst(String first, String second) {
        Logger.elog(Logger.yellow(first) + " " + second);
    }

    public static void eprintlnPlainMixedBlueFirst(String first, String second) {
        Logger.elog(Logger.blue(first) + " " + second);
    }

    public static void printlnPlainMixedYellowFirst(String first, String second, String third) {
        Logger.log(Logger.yellow(first) + " " + second + " " + Logger.yellow(third));
    }

    public static void printlnPlainMixedBlue(String first, String second) {
        Logger.log(first + " " + Logger.blue(second));
    }

    public static void eprintlnPlainMixedBlue(String first, String second) {
        Logger.elog(first + " " + Logger.blue(second));
    }

    public static void printlnPlainMixedBlue(String first, String second, String third) {
        Logger.log(first + " " + Logger.blue(second) + " " + third);
    }

    public static void eprintlnPlainMixedBlue(String first, String second, String third) {
        Logger.elog(first + " " + Logger.blue(second) + " " + third);
    }

    public static void printPlainMixedBlue(String first, String second) {
        Logger.log(first + " " + Logger.blue(second), false);
    }

    public static void printPlainMixedBlueFirst(String first, String second, String third) {
        Logger.log(Logger.blue(first) + " " + second + " " + Logger.blue(third), false);
    }

    public static void eprintlnMixedBlue(String first, String second) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.blue(second));
    }

    public static void eprintlnMixedBlue(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.blue(second) + " " + third);
    }

    public static void eprintlnMixedYellow(String first, String second) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.yellow(second));
    }

    public static void eprintlnMixedYellow(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.yellow(second) + " " + third);
    }

    public static void printlnMixedBlueFirst(String first, String second) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second);
    }

    public static void printlnMixedBlueFirst(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second + " " + Logger.blue(third));
    }

    public static void printlnPlainMixedBlueFirst(String first, String second) {
        Logger.log(Logger.blue(first) + " " + second);
    }

    public static void printlnPlainMixedBlueFirst(String first, String second, String third) {
        Logger.log(Logger.blue(first) + " " + second + " " + Logger.blue(third));
    }

    public static void printlnMixedYellowFirst(String first, String second) {
        Logger.log(Logger.prefix() + Logger.yellow(first) + " " + second);
    }

    public static void printlnMixedYellowFirst(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.yellow(first) + " " + second + " " + Logger.yellow(third));
    }

    public static void eprintlnMixedBlueFirst(String first, String second) {
        Logger.elog(Logger.eprefix() + Logger.blue(first) + " " + second);
    }

    public static void eprintlnMixedBlueFirst(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + Logger.blue(first) + " " + second + " " + Logger.blue(third));
    }

    public static void eprintMixedBlueFirst(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + Logger.blue(first) + " " + second + " " + Logger.blue(third), false);
    }

    public static void printMixedRedFirst(String first, String second) {
        Logger.log(Logger.prefix() + Logger.red(first) + " " + second, false);
    }

    public static void printMixedRedFirst(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.red(first) + " " + second + " " + Logger.red(third), false);
    }

    public static void eprintMixedRedFirst(String first, String second) {
        Logger.elog(Logger.prefix() + Logger.red(first) + " " + second, false);
    }

    public static void eprintMixedRedFirst(String first, String second, String third) {
        Logger.elog(Logger.prefix() + Logger.red(first) + " " + second + " " + Logger.red(third), false);
    }

    public static void eprintlnMixedYellowFirst(String first, String second) {
        Logger.elog(Logger.eprefix() + Logger.yellow(first) + " " + second);
    }

    public static void eprintlnMixedYellowFirst(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + Logger.yellow(first) + " " + second + " " + Logger.yellow(third));
    }

    public static void printMixedBlue(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.blue(second), false);
    }

    public static void printMixedBlue(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.blue(second) + " " + third, false);
    }

    public static void printMixedYellow(String first, String second) {
        Logger.log(Logger.prefix() + first + " " + Logger.yellow(second), false);
    }

    public static void printMixedYellow(String first, String second, String third) {
        Logger.log(Logger.prefix() + first + " " + Logger.yellow(second) + " " + third, false);
    }

    public static void eprintMixedBlue(String first, String second) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.blue(second), false);
    }

    public static void eprintMixedBlue(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.blue(second) + " " + third, false);
    }

    public static void eprintMixedYellow(String first, String second) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.yellow(second), false);
    }

    public static void eprintMixedYellow(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + first + " " + Logger.yellow(second) + " " + third, false);
    }

    public static void printMixedBlueFirst(String first, String second) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second, false);
    }

    public static void printMixedBlueFirst(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.blue(first) + " " + second + " " + Logger.blue(third), false);
    }

    public static void printMixedYellowFirst(String first, String second) {
        Logger.log(Logger.prefix() + Logger.yellow(first) + " " + second, false);
    }

    public static void printMixedYellowFirst(String first, String second, String third) {
        Logger.log(Logger.prefix() + Logger.yellow(first) + " " + second + " " + Logger.yellow(third), false);
    }

    public static void eprintMixedBlueFirst(String first, String second) {
        Logger.elog(Logger.eprefix() + Logger.blue(first) + " " + second, false);
    }

    public static void erintMixedBlueFirst(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + Logger.blue(first) + " " + second + " " + Logger.blue(third), false);
    }

    public static void eprintMixedYellowFirst(String first, String second) {
        Logger.elog(Logger.eprefix() + Logger.yellow(first) + " " + second, false);
    }

    public static void eprintMixedYellowFirst(String first, String second, String third) {
        Logger.elog(Logger.eprefix() + Logger.yellow(first) + " " + second + " " + Logger.yellow(third), false);
    }

    public static void printInfoBox() {
        Logger.lineBreak();
        Logger.printlnBlue("Info:");
        Logger.increaseIndent();
        Logger.printlnBlue("--------------------------------");
    }

    public static void statusVulnerable() {
        Logger.printlnMixedRed("  Vulnerability Status:", "Vulnerable");
    }

    public static void statusOk() {
        Logger.printlnMixedGreen("  Vulnerability Status:", "Non Vulnerable");
    }

    public static void statusOutdated() {
        Logger.printlnMixedPurple("  Configuration Status:", "Outdated");
    }

    public static void statusDefault() {
        Logger.printlnMixedGreen("  Configuration Status:", "Current Default");
    }

    public static void statusNonDefault() {
        Logger.printlnMixedRed("  Configuration Status:", "Non Default");
    }

    public static void statusUndecided(String statusType) {
        Logger.printlnMixedPurple("  " + statusType + " Status:", "Undecided");
    }

    public static void resetIndent() {
        indent = 0;
    }

    public static void increaseIndent() {
        if (printCount != 0) {
            ++indent;
        }
    }

    public static void decreaseIndent() {
        if (--indent < 0) {
            indent = 0;
        }
    }

    public static String getIndent() {
        return " " + new String(new char[indent]).replace("\u0000", "\t");
    }

    public static void disableColor() {
        ANSI_RESET = "";
        ANSI_YELLOW = "";
        ANSI_BLUE = "";
        ANSI_RED = "";
        ANSI_GREEN = "";
        ANSI_PURPLE = "";
    }

    public static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }
}

