/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.io;

import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;

public class ProgressBar {
    protected int done;
    protected int work;
    protected final int length;
    protected final String formatString;

    public ProgressBar(int work, int length) {
        this.work = work;
        this.length = length;
        this.done = 0;
        int digits = String.valueOf(work).length();
        this.formatString = "[%" + String.valueOf(digits) + "d / %d] [%s] %3d%%\r";
    }

    public void done() {
        if (!BeanshooterOption.NO_PROGRESS.getBool()) {
            Logger.lineBreak();
        }
    }

    public synchronized void addWork() {
        if (BeanshooterOption.NO_PROGRESS.getBool()) {
            return;
        }
        ++this.work;
    }

    public synchronized void taskDone() {
        if (BeanshooterOption.NO_PROGRESS.getBool()) {
            return;
        }
        ++this.done;
        this.printBar();
    }

    private void printBar() {
        float progress = (float)this.done / (float)this.work;
        int percentage = Math.round(progress * 100.0f);
        int barLength = Math.round(progress * (float)this.length);
        String progressBar = new String(new char[barLength]).replace("\u0000", "#");
        progressBar = progressBar + new String(new char[this.length - barLength]).replace("\u0000", " ");
        progressBar = String.format(this.formatString, this.done, this.work, progressBar, percentage);
        Logger.print(progressBar);
    }
}

