/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.IMBean;
import de.qtc.beanshooter.networking.JarHandler;
import de.qtc.beanshooter.networking.MLetHandler;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.operation.MBeanServerClient;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class Dispatcher
extends de.qtc.beanshooter.operation.Dispatcher {
    protected final IMBean bean;

    public Dispatcher(IMBean bean) {
        this.bean = bean;
    }

    public void stats() {
        String jarFile = this.bean.getJarName();
        Logger.printlnMixedYellow("MBean:", this.bean.getName());
        Logger.increaseIndent();
        Logger.printlnMixedBlueYellow("Object Name:", "\t", this.bean.getObjectName().toString());
        Logger.printlnMixedBlueYellow("Class Name:", "\t", this.bean.getMBeanClass());
        if (jarFile != null) {
            Logger.printlnMixedBlueYellow("Jar File:", "\t", "available (" + jarFile + ")");
        } else {
            Logger.printlnMixedBlueRed("Jar File:", "\t", "not available");
        }
        Logger.decreaseIndent();
    }

    @Override
    public void attr() {
        Attribute attrObj = null;
        String attrName = (String)ArgumentHandler.require(BeanshooterOption.ATTR_ATTRIBUTE);
        String attrValue = BeanshooterOption.ATTR_VALUE.getValue(null);
        String typeName = BeanshooterOption.ATTR_TYPE.getValue("String");
        if (attrValue != null) {
            String signature = String.format("void dummy(%s p1)", typeName);
            PluginSystem.getArgumentTypes(signature);
            Object[] argumentArray = PluginSystem.getArgumentArray(new String[]{attrValue});
            attrObj = new Attribute(attrName, argumentArray[0]);
        }
        MBeanServerClient client = this.getMBeanServerClient();
        try {
            if (attrObj != null) {
                client.setAttribute(this.bean.getObjectName(), attrObj);
            } else {
                Object result = client.getAttribute(this.bean.getObjectName(), attrName);
                if (result != null) {
                    PluginSystem.handleResponse(result);
                } else {
                    Logger.println("null");
                }
            }
        }
        catch (IOException | MBeanException | ReflectionException e) {
            Logger.printlnMixedYellow("Caught", e.getClass().getName(), String.format("while obtaining attribute %s from %s", attrName, this.bean.getObjectName()));
            Logger.println("beanshooter does not handle exceptions for custom method invocations.");
            ExceptionHandler.stackTrace(e);
        }
    }

    @Override
    public void invoke() {
        String signature = (String)ArgumentHandler.require(BeanshooterOption.INVOKE_METHOD);
        List argumentStringArray = (List)BeanshooterOption.INVOKE_METHOD_ARGS.getValue();
        String[] argumentTypes = PluginSystem.getArgumentTypes(signature);
        Object[] argumentArray = PluginSystem.getArgumentArray(argumentStringArray.toArray(new String[0]));
        String methodName = PluginSystem.getMethodName(signature);
        MBeanServerClient client = this.getMBeanServerClient();
        try {
            Object result = client.invoke(this.bean.getObjectName(), methodName, argumentTypes, argumentArray);
            if (result != null) {
                PluginSystem.handleResponse(result);
            } else {
                Logger.printlnBlue("Call was successful.");
            }
        }
        catch (IOException | MBeanException | ReflectionException e) {
            Logger.printlnMixedYellow("Caught", e.getClass().getName(), String.format("while invoking %s on %s.", methodName, this.bean.getObjectName().toString()));
            Logger.println("beanshooter does not handle exceptions for custom method invocations.");
            ExceptionHandler.stackTrace(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info() {
        List<String> keywords = Arrays.asList(ArgumentHandler.getInstance().getFromConfig("keywords").split(" "));
        List<String> methodKeywords = Arrays.asList(ArgumentHandler.getInstance().getFromConfig("methodKeywords").split(" "));
        if (BeanshooterOption.ATTR_KEYWORDS.notNull()) {
            keywords = Arrays.asList(((String)BeanshooterOption.ATTR_KEYWORDS.getValue()).split(" "));
        }
        if (BeanshooterOption.ATTR_KEYWORDS.notNull()) {
            methodKeywords = Arrays.asList(((String)BeanshooterOption.ATTR_METHOD_KEYWORDS.getValue()).split(" "));
        }
        MBeanServerClient conn = this.getMBeanServerClient();
        MBeanInfo info = conn.getMBeanInfo(this.bean.getObjectName());
        MBeanAttributeInfo[] attrs = info.getAttributes();
        MBeanOperationInfo[] opInfos = info.getOperations();
        if (!BeanshooterOption.ATTR_HARVEST.getBool()) {
            Logger.lineBreak();
            Logger.printlnMixedYellow("MBean Class:", info.getClassName());
            Logger.printlnMixedYellow("ObjectName:", this.bean.getObjectName().toString());
            Logger.lineBreak();
            Logger.increaseIndent();
            Logger.printlnYellow("Attributes:");
            Logger.increaseIndent();
            if (attrs.length != 0) {
                void var10_16;
                boolean output = false;
                MBeanAttributeInfo[] mBeanAttributeInfoArray = attrs;
                int n = mBeanAttributeInfoArray.length;
                boolean i = false;
                while (var10_16 < n) {
                    MBeanAttributeInfo attr = mBeanAttributeInfoArray[var10_16];
                    if (!BeanshooterOption.ATTR_WRITEABLE.getBool() || attr.isWritable()) {
                        if (this.listContains(keywords, attr.getName())) {
                            Logger.printMixedRedFirst(attr.getName(), "(type: ");
                        } else {
                            Logger.printMixedBlueFirst(attr.getName(), "(type: ");
                        }
                        Logger.printPlainMixedYellowFirst(attr.getType(), ", writable: ");
                        if (attr.isWritable()) {
                            Logger.printPlainGreen("true");
                        } else {
                            Logger.printPlainRed("false");
                        }
                        Logger.printlnPlain(")");
                        output = true;
                    }
                    ++var10_16;
                }
                if (!output) {
                    Logger.printlnBlue("None");
                }
            } else {
                Logger.printlnBlue("None");
            }
            Logger.decreaseIndent();
            Logger.lineBreak();
            Logger.printlnYellow("Operations:");
            Logger.increaseIndent();
            if (opInfos.length != 0) {
                for (MBeanOperationInfo mBeanOperationInfo : opInfos) {
                    if (this.listContains(methodKeywords, mBeanOperationInfo.getName())) {
                        Logger.printlnRed(Utils.getMethodString(mBeanOperationInfo));
                        continue;
                    }
                    Logger.printlnBlue(Utils.getMethodString(mBeanOperationInfo));
                }
            } else {
                Logger.printlnBlue("None");
            }
            Logger.decreaseIndent();
            Logger.decreaseIndent();
        } else {
            if (attrs.length != 0) {
                for (MBeanFeatureInfo mBeanFeatureInfo : attrs) {
                    if (BeanshooterOption.ATTR_WRITEABLE.getBool() && !((MBeanAttributeInfo)mBeanFeatureInfo).isWritable() || !this.listContains(keywords, mBeanFeatureInfo.getName())) continue;
                    Logger.print("Attribute:");
                    Logger.printPlainBlue(this.bean.getObjectName().toString());
                    Logger.printPlainMixedRed(" ::", mBeanFeatureInfo.getName());
                    Logger.printPlainMixedYellow("(type:", ((MBeanAttributeInfo)mBeanFeatureInfo).getType());
                    Logger.printPlainMixedYellow(", writable:", String.valueOf(((MBeanAttributeInfo)mBeanFeatureInfo).isWritable()));
                    Logger.printlnPlain(")");
                }
            }
            if (opInfos.length != 0) {
                for (MBeanFeatureInfo mBeanFeatureInfo : opInfos) {
                    if (!this.listContains(methodKeywords, mBeanFeatureInfo.getName())) continue;
                    Logger.print("Method:");
                    Logger.printPlainBlue(this.bean.getObjectName().toString());
                    Logger.printlnPlainMixedRed("::", Utils.getMethodString((MBeanOperationInfo)mBeanFeatureInfo));
                }
            }
        }
    }

    public boolean isDeployed() {
        ObjectName mBeanObjectName = this.bean.getObjectName();
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        return mBeanServerClient.isRegistered(mBeanObjectName);
    }

    public void status() {
        if (this.isDeployed()) {
            String className = this.bean.getMBeanClass();
            ObjectName mBeanObjectName = this.bean.getObjectName();
            Logger.printlnMixedGreen("MBean Status:", "deployed");
            Logger.increaseIndent();
            Logger.printlnMixedBlue("Class Name:", className);
            Logger.printlnMixedBlue("Object Name:", mBeanObjectName.toString());
            Logger.decreaseIndent();
        } else {
            Logger.printlnMixedRed("MBean Status:", "not deployed");
        }
    }

    @Override
    public void deploy() {
        Logger.printlnBlue("Starting MBean deployment.");
        Logger.lineBreak();
        Logger.increaseIndent();
        String mBeanClassName = this.bean.getMBeanClass();
        ObjectName mBeanObjectName = this.bean.getObjectName();
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        mBeanServerClient.deployMBean(mBeanClassName, mBeanObjectName, this.bean.getJarName());
        Logger.decreaseIndent();
    }

    @Override
    public void undeploy() {
        ObjectName mBeanObjectName = this.bean.getObjectName();
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        mBeanServerClient.unregisterMBean(mBeanObjectName);
    }

    public void export() {
        String current = null;
        JarHandler jarHandler = null;
        MLetHandler mletHandler = null;
        String exportDir = BeanshooterOption.EXPORT_DIR.getValue(".");
        String jarFileName = Utils.joinIfRelative(exportDir, BeanshooterOption.EXPORT_JAR.getValue(this.bean.getJarName())).toString();
        String mLetFileName = Utils.joinIfRelative(exportDir, BeanshooterOption.EXPORT_MLET.getValue("index.html")).toString();
        String jarName = new File(jarFileName).getName();
        try {
            if (BeanshooterOption.EXPORT_JAR.notNull() || BeanshooterOption.EXPORT_MLET.isNull()) {
                jarHandler = new JarHandler(this.bean.getJarName(), null);
                current = jarFileName;
                jarHandler.export(jarFileName);
            }
            if (BeanshooterOption.EXPORT_MLET.notNull() || BeanshooterOption.EXPORT_JAR.isNull()) {
                URL url = Utils.parseUrl((String)ArgumentHandler.require(BeanshooterOption.EXPORT_URL));
                mletHandler = new MLetHandler(url, this.bean.getMBeanClass(), jarName, this.bean.getObjectName().toString(), null);
                current = mLetFileName;
                mletHandler.export(mLetFileName);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, current, true);
        }
    }

    private boolean listContains(List<String> list, String match) {
        match = match.toLowerCase();
        list = list.stream().map(String::toLowerCase).collect(Collectors.toList());
        return list.stream().anyMatch(match::contains);
    }
}

