/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.OpenTypeException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import org.jolokia.client.exception.J4pRemoteException;

public class MBeanInvocationHandler
implements InvocationHandler {
    private final MBeanServerConnection conn;
    private final ObjectName objName;

    public MBeanInvocationHandler(ObjectName objName, MBeanServerConnection conn) {
        this.objName = objName;
        this.conn = conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retValue = null;
        try {
            retValue = method.getName().equals("getAttribute") ? this.conn.getAttribute(this.objName, (String)args[0]) : this.conn.invoke(this.objName, method.getName(), args, Utils.typesToString(method.getParameterTypes()));
        }
        catch (InstanceNotFoundException e) {
            Logger.resetIndent();
            if (Logger.printCount != 0) {
                Logger.lineBreak();
            }
            ExceptionHandler.handleInstanceNotFound(e, this.objName.toString());
        }
        catch (ReflectionException e) {
            Throwable t;
            Logger.resetIndent();
            if (Logger.printCount != 0) {
                Logger.lineBreak();
            }
            if ((t = ExceptionHandler.getCause(e)) instanceof NoSuchMethodException) {
                ExceptionHandler.noSuchMethod(e, Utils.getMethodString(method));
            } else {
                ExceptionHandler.unexpectedException(e, "invoke", "operation", true);
            }
        }
        catch (SecurityException e) {
            String message = e.getMessage();
            if (message.contains("Access denied!")) {
                ExceptionHandler.mBeanAccessDenied(e, this.objName.toString(), method.getName());
            }
            throw e;
        }
        catch (MBeanException e) {
            Throwable cause = ExceptionHandler.getCause(e);
            if (cause instanceof J4pRemoteException) {
                String message = cause.getMessage();
                String[] split = message.split(":", 3);
                String exceptionName = split[1].trim();
                String exceptionMessage = split[2].trim();
                try {
                    Class<?> exceptionClass = Class.forName(exceptionName);
                    Constructor<?> constr = exceptionClass.getDeclaredConstructor(String.class);
                    if (Exception.class.isAssignableFrom(exceptionClass)) {
                        if (exceptionName.startsWith("java.lang.Illegal")) {
                            throw new RuntimeMBeanException((RuntimeException)constr.newInstance(exceptionMessage), "Forwarded Jolokia Exception");
                        }
                        throw new MBeanException((Exception)constr.newInstance(exceptionMessage), "Forwarded Jolokia Exception");
                    }
                }
                catch (ClassCastException | ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                Logger.eprintlnMixedYellow("Caught", "J4pRemoteException", "during MBean method invocation.");
                Logger.eprintlnMixedBlue("Jolokia reported:", message);
                Utils.exit(e);
            }
            throw e;
        }
        return MBeanInvocationHandler.openTypeConverter(method.getReturnType(), retValue);
    }

    private static Object openTypeConverter(Class<?> expected, Object value) throws Throwable {
        if (expected == Set.class && value instanceof CompositeData[]) {
            HashSet<OpenTypeException> retSet = new HashSet<OpenTypeException>();
            for (CompositeData compItem : (CompositeData[])value) {
                for (Object item : compItem.values()) {
                    if (!(item instanceof String) || !item.toString().contains("Exception")) continue;
                    retSet.add(new OpenTypeException(item.toString()));
                }
            }
            return retSet;
        }
        if (expected == byte[].class && value instanceof Long[]) {
            Long[] values = (Long[])value;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int ctr = 0; ctr < values.length; ++ctr) {
                dos.writeLong(values[ctr]);
            }
            return baos.toByteArray();
        }
        return value;
    }
}

