/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.diagnostic;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.mbean.diagnostic.DiagnosticCommandOption;
import de.qtc.beanshooter.mbean.diagnostic.Dispatcher;
import de.qtc.beanshooter.operation.BeanshooterOption;
import java.lang.reflect.Method;

public enum DiagnosticCommandOperation implements Operation
{
    READ("readFile", "use addCompilerDirective to read a file", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, DiagnosticCommandOption.FILENAME, DiagnosticCommandOption.RAW}),
    LOAD("loadLibrary", "load a shared library", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, DiagnosticCommandOption.LIBRARY_PATH}),
    LOGFILE("setLogfile", "set the log location of the Java VM", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, DiagnosticCommandOption.FILENAME}),
    NOLOG("disableLogging", "disable logging of the Java VM", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL}),
    CMDLINE("getCommandLine", "get the Java virtual machine command line", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL}),
    PROPS("getSystemProperties", "get Java virtual machine System properties", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL});

    private Method method;
    private String description;
    private Option[] options;
    private Dispatcher dispatcher;

    private DiagnosticCommandOperation(String methodName, String description, Option[] options) {
        try {
            this.method = Dispatcher.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation constructor", true);
        }
        this.description = description;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean containsOption(Option option) {
        for (Option o : this.options) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invoke() {
        if (this.dispatcher == null) {
            this.dispatcher = new Dispatcher();
        }
        try {
            this.method.invoke((Object)this.dispatcher, new Object[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation.invoke(...)", true);
        }
    }
}

