/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.flightrecorder;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.flightrecorder.FlightRecorderMXBean;
import de.qtc.beanshooter.mbean.flightrecorder.FlightRecorderOption;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private final FlightRecorderMXBean recorder;

    public Dispatcher() {
        super(MBean.FLIGHT_RECORDER);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.recorder = (FlightRecorderMXBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{FlightRecorderMXBean.class}, (InvocationHandler)invo);
    }

    public void newRecording() {
        Logger.printlnBlue("Requesting new recording on the MBeanServer.");
        try {
            long recordingID = this.recorder.newRecording();
            Logger.printlnMixedYellow("New recording created successfully with ID:", String.valueOf(recordingID));
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "creation of", "new recording", true);
        }
    }

    public void startRecording() {
        long recordingID = ((Integer)ArgumentHandler.require(FlightRecorderOption.RECORDING_ID)).intValue();
        try {
            this.recorder.startRecording(recordingID);
            Logger.printlnMixedYellow("Recording with ID", String.valueOf(recordingID), "started successfully.");
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("No recording available with id")) {
                Logger.eprintlnMixedYellow("A recording with ID", String.valueOf(recordingID), "does not exist.");
            } else if (t instanceof IllegalStateException && t.getMessage().contains("Recording can only be started once")) {
                Logger.eprintlnMixedYellow("The recording with ID", String.valueOf(recordingID), "was already started.");
            } else {
                ExceptionHandler.unexpectedException(e, "starting", "recording", true);
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "starting", "recording", true);
        }
    }

    public void stopRecording() {
        long recordingID = ((Integer)ArgumentHandler.require(FlightRecorderOption.RECORDING_ID)).intValue();
        try {
            this.recorder.stopRecording(recordingID);
            Logger.printlnMixedYellow("Recording with ID", String.valueOf(recordingID), "stopped successfully.");
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("No recording available with id")) {
                Logger.eprintlnMixedYellow("A recording with ID", String.valueOf(recordingID), "does not exist.");
            } else if (t instanceof IllegalStateException && t.getMessage().contains("Recording must be started before it can be stopped")) {
                Logger.eprintlnMixedYellow("The recording with ID", String.valueOf(recordingID), "was not started yet.");
            } else if (t instanceof IllegalStateException && t.getMessage().contains("Can't stop an already stopped recording")) {
                Logger.eprintlnMixedYellow("The recording with ID", String.valueOf(recordingID), "was already stopped.");
            } else {
                ExceptionHandler.unexpectedException(e, "stopping", "recording", true);
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "stopping", "recording", true);
        }
    }

    public void saveRecording() {
        long recordingID = ((Integer)ArgumentHandler.require(FlightRecorderOption.RECORDING_ID)).intValue();
        Path filename = Paths.get((String)ArgumentHandler.require(FlightRecorderOption.DUMP_FILE), new String[0]);
        String filenameStr = filename.normalize().toAbsolutePath().toString();
        Logger.printlnMixedYellow("Saving recording with ID:", String.valueOf(recordingID));
        try {
            long streamID = this.recorder.openStream(recordingID, null);
            byte[] content = this.recorder.readStream(streamID);
            this.recorder.closeStream(streamID);
            Logger.printlnMixedYellow("Writing recording data to:", filenameStr);
            Files.write(filename, content, new OpenOption[0]);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("No recording available with id")) {
                Logger.eprintlnMixedYellow("A recording with ID", String.valueOf(recordingID), "does not exist.");
            } else {
                ExceptionHandler.unexpectedException(e, "saving", "recording", true);
            }
        }
        catch (MBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IOException && t.getMessage().contains("Recording must be stopped")) {
                Logger.eprintlnMixedYellow("The specified recording", "must be stopped", "before it can be saved.");
            } else {
                ExceptionHandler.unexpectedException(e, "saving", "recording", true);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, filenameStr, true);
        }
    }

    public void dumpRecording() {
        long recordingID = ((Integer)ArgumentHandler.require(FlightRecorderOption.RECORDING_ID)).intValue();
        String filename = (String)ArgumentHandler.require(FlightRecorderOption.DUMP_FILE);
        try {
            this.recorder.copyTo(recordingID, filename);
            Logger.printMixedYellow("Recording with ID", String.valueOf(recordingID), "was successfully dumped to ");
            Logger.printlnPlainBlue(filename);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("No recording available with id")) {
                Logger.eprintlnMixedYellow("A recording with ID", String.valueOf(recordingID), "does not exist.");
            } else {
                ExceptionHandler.unexpectedException(e, "dumping", "recording", true);
            }
        }
        catch (MBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IOException) {
                if (t.getMessage().contains("has not started")) {
                    Logger.eprintlnMixedYellow("Recording with ID", String.valueOf(recordingID), "was not started yet.");
                    Logger.eprintlnMixedBlue("Nothing to dump.", "Start the recording", "first.");
                } else {
                    Logger.eprintlnMixedYellow("Dumping recording to file on the JMX server caused an", "IOException.");
                    ExceptionHandler.handleFileWrite(t, filename, true);
                }
            }
            ExceptionHandler.unexpectedException(e, "dumping", "recording", true);
        }
    }
}

