/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.hotspot;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.hotspot.HotSpotDiagnosticMXBean;
import de.qtc.beanshooter.mbean.hotspot.HotSpotDiagnosticOption;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.MBeanException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private final HotSpotDiagnosticMXBean diagnostic;

    public Dispatcher() {
        super(MBean.HOTSPOT_DIAGNOSTIC);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.diagnostic = (HotSpotDiagnosticMXBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{HotSpotDiagnosticMXBean.class}, (InvocationHandler)invo);
    }

    public void dumpHeap() {
        String filename = (String)ArgumentHandler.require(HotSpotDiagnosticOption.DUMP_FILE);
        boolean live = HotSpotDiagnosticOption.LIVE.getBool();
        try {
            this.diagnostic.dumpHeap(filename, live);
            Logger.printlnMixedYellow("Heapdump file", filename, "was created successfully.");
        }
        catch (MBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IOException) {
                Logger.eprintlnMixedYellow("Saving heapdump on the server caused an", "IOException.");
                ExceptionHandler.handleFileWrite(t, filename, true);
            }
            ExceptionHandler.unexpectedException(e, "creating", "heapdump", true);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("must have .hprof extention")) {
                Logger.eprintlnMixedYellow("Heapdump file must have", ".hprof", "extention.");
            }
            ExceptionHandler.unexpectedException(e, "creating", "heapdump", true);
        }
    }

    public void listOptions() {
        try {
            CompositeData[] options;
            for (CompositeData option : options = (CompositeData[])this.diagnostic.getAttribute("DiagnosticOptions")) {
                Logger.printMixedBlueFirst(option.get("name").toString(), "(");
                Logger.printPlainMixedBlue("value =", option.get("value").toString());
                Logger.printPlainMixedBlue(", writable =", option.get("writeable").toString());
                Logger.printlnPlain(")");
            }
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "listing", "diagnostic options", true);
        }
    }

    public void getOption() {
        String vmOption = (String)ArgumentHandler.require(HotSpotDiagnosticOption.OPTION_NAME);
        try {
            CompositeData option = this.diagnostic.getVMOption(vmOption);
            Logger.printlnMixedYellow("Name:", String.valueOf(option.get("name")));
            Logger.printlnMixedBlue("Value:", String.valueOf(option.get("value")));
            Logger.printlnMixedBlue("Writable:", String.valueOf(option.get("writeable")));
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "getting", "VMOption", true);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalArgumentException && t.getMessage().contains("does not exist")) {
                Logger.eprintlnMixedYellow("A VMOption with name", vmOption, "does not exist on the remote server.");
            }
            ExceptionHandler.unexpectedException(e, "getting", "VMOption", true);
        }
    }

    public void setOption() {
        String vmOption = (String)ArgumentHandler.require(HotSpotDiagnosticOption.OPTION_NAME);
        String optionValue = (String)ArgumentHandler.require(HotSpotDiagnosticOption.OPTION_VALUE);
        try {
            this.diagnostic.setVMOption(vmOption, optionValue);
            Logger.printlnBlue("Option was set successfully.");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "setting", "VMOption", true);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getThrowable("IllegalArgumentException", e);
            if (t != null) {
                String message = t.getMessage();
                if (message.contains("does not exist")) {
                    Logger.eprintlnMixedYellow("A VMOption with name", vmOption, "does not exist on the remote server.");
                } else if (message.contains("Invalid value") || message.contains("error: ")) {
                    Logger.eprintlnMixedYellow("The specified value", optionValue, "is invalid.");
                    Logger.eprintlnBlue(message);
                } else {
                    ExceptionHandler.unexpectedException(e, "setting", "VMOption", true);
                }
            }
            ExceptionHandler.unexpectedException(e, "setting", "VMOption", true);
        }
    }
}

