/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.mbean.tonkabean;

import de.qtc.beanshooter.cli.Operation;
import de.qtc.beanshooter.cli.Option;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.mbean.tonkabean.Dispatcher;
import de.qtc.beanshooter.mbean.tonkabean.TonkaBeanOption;
import de.qtc.beanshooter.operation.BeanshooterOption;
import java.lang.reflect.Method;

public enum TonkaBeanOperation implements Operation
{
    VERSION("version", "obtain version information from a deployed tonka bean", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL}),
    EXEC("execute", "execute a command on the MBeanServer", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, TonkaBeanOption.EXEC_CMD, TonkaBeanOption.EXEC_ENV, TonkaBeanOption.EXEC_CWD, TonkaBeanOption.EXEC_FILE, TonkaBeanOption.EXEC_HEX, TonkaBeanOption.EXEC_RAW, TonkaBeanOption.EXEC_BACK, TonkaBeanOption.SHELL_CMD}),
    EXECARRAY("executeArray", "execute a command specified as array on the MBeanServer", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, TonkaBeanOption.EXEC_ARRAY, TonkaBeanOption.EXEC_ENV, TonkaBeanOption.EXEC_CWD, TonkaBeanOption.EXEC_FILE, TonkaBeanOption.EXEC_HEX, TonkaBeanOption.EXEC_RAW, TonkaBeanOption.EXEC_BACK}),
    SHELL("shell", "start an semi interactive shell", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, TonkaBeanOption.SHELL_CMD}),
    UPLOAD("upload", "upload a file to the MBeanServer", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, TonkaBeanOption.UPLOAD_DEST, TonkaBeanOption.UPLOAD_SOURCE}),
    DOWNLOAD("download", "download a file from the MBean server", new Option[]{BeanshooterOption.GLOBAL_CONFIG, BeanshooterOption.GLOBAL_VERBOSE, BeanshooterOption.GLOBAL_PLUGIN, BeanshooterOption.GLOBAL_NO_COLOR, BeanshooterOption.GLOBAL_STACK_TRACE, BeanshooterOption.TARGET_HOST, BeanshooterOption.TARGET_PORT, BeanshooterOption.TARGET_BOUND_NAME, BeanshooterOption.TARGET_OBJID_SERVER, BeanshooterOption.TARGET_OBJID_CONNECTION, BeanshooterOption.CONN_FOLLOW, BeanshooterOption.CONN_SSL, BeanshooterOption.CONN_JMXMP, BeanshooterOption.CONN_JOLOKIA, BeanshooterOption.CONN_JOLOKIA_ENDPOINT, BeanshooterOption.CONN_JOLOKIA_PROXY, BeanshooterOption.CONN_JOLOKIA_PROXY_USER, BeanshooterOption.CONN_JOLOKIA_PROXY_PASS, BeanshooterOption.CONN_USER, BeanshooterOption.CONN_PASS, BeanshooterOption.CONN_SASL, TonkaBeanOption.DOWNLOAD_DEST, TonkaBeanOption.DOWNLOAD_SOURCE});

    private Method method;
    private String description;
    private Option[] options;
    private Dispatcher dispatcher;

    private TonkaBeanOperation(String methodName, String description, Option[] options) {
        try {
            this.method = Dispatcher.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation constructor", true);
        }
        this.description = description;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean containsOption(Option option) {
        for (Option o : this.options) {
            if (o != option) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invoke() {
        if (this.dispatcher == null) {
            this.dispatcher = new Dispatcher();
        }
        try {
            this.method.invoke((Object)this.dispatcher, new Object[0]);
        }
        catch (Exception e) {
            ExceptionHandler.internalException(e, "Operation.invoke(...)", true);
        }
    }
}

