/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.StagerServer;
import de.qtc.beanshooter.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;

public class JarHandler
implements HttpHandler {
    private final String digest;
    private final byte[] jarContent;
    private final StagerServer parent;

    public JarHandler(String filename, StagerServer parent) throws IOException {
        this.parent = parent;
        this.jarContent = this.getJar(filename);
        this.digest = Utils.md5sum(this.jarContent);
    }

    private byte[] getJar(String filename) throws IOException {
        byte[] content = null;
        InputStream stream = this.getClass().getResourceAsStream("/" + filename);
        if (stream != null && (content = IOUtils.toByteArray(stream)).length != 0) {
            return content;
        }
        File file = new File(filename);
        if (file.exists()) {
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                ExceptionHandler.handleFileRead(e, file.getAbsolutePath(), true);
            }
        } else {
            Logger.resetIndent();
            Logger.lineBreak();
            Logger.eprintln("Error while creating HTTP JarHandler.");
            Logger.eprintlnMixedYellow("Unable to find jar file with path:", filename);
            Utils.exit();
        }
        return content;
    }

    public void export(String filename) throws IOException {
        Logger.printlnMixedYellow("Exporting MBean jar file:", filename);
        File file = new File(filename);
        Files.write(file.toPath(), this.jarContent, new OpenOption[0]);
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        if (this.parent.isStagerOnly()) {
            Logger.printlnPlain("");
            Logger.lineBreak();
        }
        String requestURL = t.getRequestURI().toString();
        InetSocketAddress requestee = t.getRemoteAddress();
        Logger.printlnMixedYellow("Incoming request from:", requestee.getHostName());
        Logger.printlnMixedYellow("Requested resource:", requestURL);
        if (this.parent.isStagerOnly()) {
            Logger.printMixedBlue("Sending jar file with md5sum:", this.digest);
        } else {
            Logger.printlnMixedBlue("Sending jar file with md5sum:", this.digest);
            Logger.lineBreak();
        }
        t.sendResponseHeaders(200, this.jarContent.length);
        OutputStream os = t.getResponseBody();
        os.write(this.jarContent, 0, this.jarContent.length);
        os.close();
    }
}

