/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMISocketFactory;

public class LoopbackSocketFactory
extends RMISocketFactory {
    private String host;
    private RMISocketFactory fac;
    private boolean printInfo = true;
    private boolean followRedirect = false;

    public LoopbackSocketFactory(String host, RMISocketFactory fac, boolean followRedirect) {
        this.host = host;
        this.fac = fac;
        this.followRedirect = followRedirect;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.fac.createServerSocket(port);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket sock = null;
        if (!this.host.equals(host)) {
            if (this.printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                Logger.printInfoBox();
                Logger.printlnMixedBlue("RMI object tries to connect to different remote host:", host);
            }
            if (this.followRedirect) {
                if (this.printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                    Logger.println("Following redirect to new target...");
                }
            } else {
                host = this.host;
                if (this.printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                    Logger.printlnMixedBlue("Redirecting the connection back to", host);
                    Logger.printlnMixedYellow("You can use", "--follow", "to prevent this.");
                }
            }
            if (this.printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                Logger.decreaseIndent();
            }
            this.printInfo = false;
        }
        try {
            sock = this.fac.createSocket(host, port);
        }
        catch (UnknownHostException e) {
            ExceptionHandler.unknownHost(e, host, true);
        }
        return sock;
    }
}

