/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.operation.BeanshooterOption;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class LoopbackSslSocketFactory
extends SSLSocketFactory {
    public static String host = "";
    public static SSLSocketFactory fac = null;
    public static boolean printInfo = true;
    public static boolean followRedirect = false;

    @Override
    public Socket createSocket(String target, int port) throws IOException {
        Socket sock = null;
        if (!host.equals(target)) {
            if (printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                Logger.printInfoBox();
                Logger.printlnMixedBlue("RMI object tries to connect to different remote host:", target);
            }
            if (followRedirect) {
                if (printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                    Logger.println("Following SSL redirect to new target...");
                }
            } else {
                target = host;
                if (printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                    Logger.printlnMixedBlue("Redirecting the SSL connection back to", host);
                    Logger.printlnMixedYellow("You can use", "--follow", "to prevent this.");
                }
            }
            if (printInfo && BeanshooterOption.GLOBAL_VERBOSE.getBool()) {
                Logger.decreaseIndent();
            }
            printInfo = false;
        }
        try {
            sock = fac.createSocket(host, port);
        }
        catch (UnknownHostException e) {
            ExceptionHandler.unknownHost(e, host, true);
        }
        return sock;
    }

    @Override
    public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
        return fac.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return fac.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return fac.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return fac.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return fac.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return fac.createSocket(arg0, arg1, arg2, arg3);
    }
}

