/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.RMIEndpoint;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RMIRegistryEndpoint
extends RMIEndpoint {
    private Registry rmiRegistry;
    private Map<String, Remote> remoteObjectCache = new HashMap<String, Remote>();
    private static boolean setupComplete = false;

    public RMIRegistryEndpoint(String host, int port) {
        super(host, port);
        RMIRegistryEndpoint.SocketFactorySetup(host, port);
        try {
            this.rmiRegistry = LocateRegistry.getRegistry(host, port, this.csf);
        }
        catch (RemoteException e) {
            ExceptionHandler.internalError("RMIRegistryEndpoint.locateRegistry", "Caught unexpected RemoteException.");
            Utils.exit(e);
        }
    }

    public RMIRegistryEndpoint(RMIEndpoint rmi) {
        this(rmi.host, rmi.port);
    }

    private static synchronized void SocketFactorySetup(String host, int port) {
        if (setupComplete) {
            return;
        }
        try {
            RMISocketFactory.setSocketFactory(PluginSystem.getDefaultRMISocketFactory(host, port));
        }
        catch (IOException e) {
            Logger.eprintlnMixedBlue("Unable to set custom", "RMISocketFactory.", "Host redirection will probably not work.");
            ExceptionHandler.showStackTrace(e);
            Logger.eprintln("");
        }
        Security.setProperty("ssl.SocketFactory.provider", PluginSystem.getDefaultSSLSocketFactoryClass(host, port));
        setupComplete = true;
    }

    public String[] getBoundNames() {
        if (BeanshooterOption.TARGET_BOUND_NAME.notNull()) {
            return new String[]{(String)BeanshooterOption.TARGET_BOUND_NAME.getValue()};
        }
        String[] boundNames = null;
        try {
            boundNames = this.rmiRegistry.list();
        }
        catch (ConnectIOException e) {
            ExceptionHandler.connectIOException(e, "list");
        }
        catch (ConnectException e) {
            ExceptionHandler.connectException(e, "list");
        }
        catch (UnknownHostException e) {
            ExceptionHandler.unknownHost(e, this.host, true);
        }
        catch (NoSuchObjectException e) {
            Logger.printlnMixedYellow("Caught", "NoSuchObjectException", "during list operation.");
            Logger.printlnMixedBlue("The specified endpoint", "is not", "an RMI registry.");
            Utils.exit(e);
        }
        catch (Exception e) {
            ExceptionHandler.unexpectedException(e, "list", "call", true);
        }
        return boundNames;
    }

    public Remote[] lookup(String[] boundNames) {
        ArrayList<Remote> remoteObjects = new ArrayList<Remote>();
        for (String boundName : boundNames) {
            try {
                remoteObjects.add(this.lookup(boundName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return remoteObjects.toArray(new Remote[0]);
    }

    public Remote lookup(String boundName) throws ClassNotFoundException {
        Remote remoteObject = this.remoteObjectCache.get(boundName);
        if (remoteObject == null) {
            try {
                remoteObject = this.rmiRegistry.lookup(boundName);
                this.remoteObjectCache.put(boundName, remoteObject);
            }
            catch (ConnectIOException e) {
                ExceptionHandler.connectIOException(e, "lookup");
            }
            catch (ConnectException e) {
                ExceptionHandler.connectException(e, "lookup");
            }
            catch (UnknownHostException e) {
                ExceptionHandler.unknownHost(e, this.host, true);
            }
            catch (NoSuchObjectException e) {
                ExceptionHandler.noSuchObjectException(e, "registry", true);
            }
            catch (NotBoundException e) {
                ExceptionHandler.notBoundException(e, boundName);
            }
            catch (Exception e) {
                Throwable cause = ExceptionHandler.getCause(e);
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                ExceptionHandler.unexpectedException(e, "lookup", "call", true);
            }
        }
        return remoteObject;
    }

    public Remote getFromCache(String boundName) {
        return this.remoteObjectCache.get(boundName);
    }
}

