/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import com.sun.net.httpserver.HttpServer;
import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.JarHandler;
import de.qtc.beanshooter.networking.MLetHandler;
import de.qtc.beanshooter.operation.BeanshooterOperation;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.UUID;

public class StagerServer {
    private final int port;
    private final String host;
    private final boolean stagerOnly;
    private HttpServer server;

    public StagerServer(String host, int port, boolean stagerOnly) {
        this.host = host;
        this.port = port;
        this.stagerOnly = stagerOnly;
    }

    public boolean isStagerOnly() {
        return this.stagerOnly;
    }

    public void start(URL url, String jarFile, String beanClass, String objectName) {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.host, this.port), 0);
            Logger.printlnMixedBlue("Creating HTTP server on:", this.host + ":" + this.port);
            String jarName = UUID.randomUUID().toString().replace("-", "");
            Logger.printlnMixedBlue("Creating MLetHandler for endpoint:", "/");
            this.server.createContext("/", new MLetHandler(url, beanClass, jarName, objectName, this));
            Logger.printlnMixedBlue("Creating JarHandler for endpoint:", "/" + jarName);
            this.server.createContext("/" + jarName, new JarHandler(jarFile, this));
            this.server.setExecutor(null);
            Logger.printlnYellow("Waiting for incoming connections...");
            Logger.println("");
            this.server.start();
        }
        catch (IOException e) {
            Throwable t = ExceptionHandler.getCause(e);
            Logger.resetIndent();
            Logger.eprintlnMixedYellow("Caught", t.getClass().getName(), "while creating the stager server.");
            if (t instanceof BindException) {
                Logger.eprintlnMixedBlue("The endpoint", String.format("%s:%s", this.host, this.port), "is probably in use or has no local interface.");
                if (ArgumentHandler.getInstance().getAction() != BeanshooterOperation.STAGER) {
                    Logger.eprintlnMixedYellow("Specify", BeanshooterOption.DEPLOY_NO_STAGER.getName(), "if you use an external stager server.");
                }
            } else if (t instanceof SocketException && t.getMessage().contains("Permission denied")) {
                Logger.eprintlnMixedBlue("You don't have sufficient permissions to bind port", String.valueOf(this.port), "on this host.");
            } else {
                ExceptionHandler.unknownReason(e);
            }
            Utils.exit(e);
        }
        catch (IllegalArgumentException e) {
            Logger.resetIndent();
            if (e.getMessage().contains("port out of range")) {
                Logger.eprintlnMixedYellow("Caught", "IllegalArgumentException", "while creating the stager server.");
                Logger.eprintlnMixedBlue("The specified port", String.valueOf(this.port), "is out of range.");
                Logger.eprintlnMixedYellow("Specify a port within the range", String.format("0-%s", 65535));
                Utils.exit(e);
            }
            ExceptionHandler.unknownReason(e);
        }
    }

    public void stop() {
        this.server.stop(0);
    }
}

