/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.networking;

import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.DummyTrustManager;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrustAllSocketFactory
implements RMIClientSocketFactory {
    private SSLSocketFactory fax;
    private int readTimeout;
    private int connectTimeout;

    public TrustAllSocketFactory() {
        this(30000, 30000);
    }

    public TrustAllSocketFactory(int readTimeout, int connectTimeout) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{new DummyTrustManager()}, null);
            this.fax = ctx.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            Logger.eprintlnMixedBlue("Unable to create", "TrustAllSocketFactory", "for SSL connections.");
            Utils.exit(e);
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket sock = this.fax.createSocket();
        sock.setSoTimeout(this.readTimeout);
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        sock.connect(sockAddr, this.connectTimeout);
        return sock;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.fax;
    }
}

