/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.operation;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.cli.SASLMechanism;
import de.qtc.beanshooter.exceptions.ApacheKarafException;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.GlassFishException;
import de.qtc.beanshooter.exceptions.InvalidLoginClassException;
import de.qtc.beanshooter.exceptions.MismatchedURIException;
import de.qtc.beanshooter.exceptions.MissingCredentialsException;
import de.qtc.beanshooter.exceptions.SaslMissingException;
import de.qtc.beanshooter.exceptions.SaslProfileException;
import de.qtc.beanshooter.exceptions.SaslSuperflousException;
import de.qtc.beanshooter.exceptions.WrongCredentialsException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.mbean.MBean;
import de.qtc.beanshooter.networking.RMIRegistryEndpoint;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.operation.MBeanServerClient;
import de.qtc.beanshooter.plugin.PluginSystem;
import de.qtc.beanshooter.utils.Utils;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.jmxadapter.RemoteJmxAdapter;

public class EnumHelper {
    private final String host;
    private final int port;
    private MBeanServerClient client;

    public EnumHelper(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void boundNames() {
        if (BeanshooterOption.CONN_JMXMP.getBool() || BeanshooterOption.CONN_JNDI.notNull() || BeanshooterOption.CONN_JOLOKIA.getBool()) {
            return;
        }
        if (BeanshooterOption.TARGET_OBJID_CONNECTION.notNull() || BeanshooterOption.TARGET_OBJID_SERVER.notNull()) {
            return;
        }
        if (BeanshooterOption.TARGET_BOUND_NAME.notNull()) {
            return;
        }
        RMIRegistryEndpoint regEndpoint = new RMIRegistryEndpoint(this.host, this.port);
        String[] boundNames = regEndpoint.getBoundNames();
        HashMap<String, Remote> mappings = new HashMap<String, Remote>();
        for (String boundName : boundNames) {
            try {
                Remote remote = regEndpoint.lookup(boundName);
                mappings.put(boundName, remote);
            }
            catch (ClassNotFoundException remote) {
                // empty catch block
            }
        }
        Map<String, Remote> jmxMap = Utils.filterJmxEndpoints(mappings);
        int jmxEndpoints = jmxMap.size();
        if (jmxEndpoints == 0) {
            Logger.printlnMixedYellow("The specified RMI registry", "does not", "contain any JMX objects.");
            Utils.exit();
        }
        Logger.printlnBlue("Checking available bound names:");
        Logger.lineBreak();
        Logger.increaseIndent();
        for (Map.Entry entry : mappings.entrySet()) {
            Logger.printMixedBlue("*", (String)entry.getKey());
            String target = "";
            try {
                target = ": " + Utils.getJmxTarget((Remote)entry.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jmxMap.containsKey(entry.getKey())) {
                Logger.printlnPlainYellow(" (JMX endpoint" + target + ")");
                continue;
            }
            Logger.printlnPlain("");
        }
        Logger.lineBreak();
        String selected = (String)jmxMap.keySet().toArray()[0];
        BeanshooterOption.TARGET_BOUND_NAME.setValue(selected);
        if (jmxEndpoints > 1) {
            Logger.printlnMixedYellow("- Found", String.valueOf(jmxEndpoints), "bound names that map to JMX services.");
            Logger.printlnMixedBlue("  The bound name", selected, "is used for enumeration.");
            Logger.printlnMixedYellow("  Use the", "--bound-name", "option to select a different one.");
            Logger.lineBreak();
        }
        Logger.decreaseIndent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean login() {
        env = ArgumentHandler.getEnv();
        Logger.printlnBlue("Checking specified credentials:");
        Logger.lineBreak();
        Logger.increaseIndent();
        try {
            conn = PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            Logger.printlnMixedYellow("-", "Login successful!", "The specified credentials are correct.");
            Logger.printMixedBlue("  Username:", (String)BeanshooterOption.CONN_USER.getValue(), " - ");
            Logger.printlnPlainMixedBlue("Password:", (String)BeanshooterOption.CONN_PASS.getValue());
            this.client = new MBeanServerClient(conn);
            var3_6 = true;
            return var3_6;
        }
        catch (AuthenticationException e) {
            block16: {
                block15: {
                    block13: {
                        if (!(e instanceof SaslSuperflousException)) break block13;
                        Logger.eprintlnMixedYellow("- Caught", "SaslSuperflousException", "during login attempt.");
                        BeanshooterOption.CONN_SASL.setValue(null);
                        env2 = PluginSystem.getEnv(null, null);
                        try {
                            conn = PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env2);
                            this.client = new MBeanServerClient(conn);
                            Logger.eprintlnMixedBlue("  Authentication was used despite the server", "does not", "require authentication.");
                            Logger.statusVulnerable();
                            var5_10 = true;
                            return var5_10;
                        }
                        catch (Exception e2) {
                            Logger.eprintln("  Reconnecting without SASL failed. You can retry without specifying credentials.");
                            Logger.statusUndecided("Configuration");
                            ** break block14
                        }
                    }
                    if (!(e instanceof SaslProfileException)) break block15;
                    Logger.eprintlnMixedYellow("- Caught", "SaslProfileException", "during login attempt.");
                    Logger.eprintlnMixedBlue("  Mismatching SASL profile. You can try to use", "--ssl", "or a different SASL profile.");
                    Logger.statusUndecided("Configuration");
                    ** GOTO lbl-1000
                }
                if (!(e instanceof MismatchedURIException)) break block16;
                Logger.eprintlnMixedYellow("- Caught", "MismatchedURIException", "during login attempt.");
                Logger.eprintlnMixedBlue("  Target needs to be accessed by the following hostname:", ((MismatchedURIException)e).getUri());
                Logger.statusUndecided("Configuration");
                ** GOTO lbl-1000
            }
            Logger.printlnMixedYellow("- Caught", "AuthenticationException", "during login attempt.");
            Logger.println("  The specified credentials are probably invalid.");
            Logger.statusUndecided("Configuration");
lbl-1000:
            // 4 sources

            {
                ExceptionHandler.showStackTrace(e);
            }
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during login attempt");
        }
        catch (Exception e) {
            Logger.printlnMixedYellow("- Caught unexpected", e.getClass().getName(), "during login attempt.");
            Logger.statusUndecided("Configuration");
            ExceptionHandler.showStackTrace(e);
        }
        finally {
            Logger.decreaseIndent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enumAccess() {
        Map<String, Object> env = PluginSystem.getEnv(null, null);
        Logger.printlnBlue("Checking for unauthorized access:");
        Logger.lineBreak();
        Logger.increaseIndent();
        try {
            MBeanServerConnection conn = PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            Logger.printlnMixedYellow("- Remote MBean server", "does not", "require authentication.");
            Logger.statusVulnerable();
            this.client = new MBeanServerClient(conn);
            boolean bl = true;
            return bl;
        }
        catch (ApacheKarafException e) {
            Logger.printlnMixedYellow("- Remote MBean server", "requires authentication", "(Apache Karaf)");
            Logger.statusOk();
            Logger.decreaseIndent();
            Logger.lineBreak();
            boolean bl = this.enumKaraf();
            return bl;
        }
        catch (GlassFishException e) {
            Logger.printlnMixedYellow("- Remote MBean server", "requires authentication", "(GlassFish)");
            Logger.statusOk();
            Logger.decreaseIndent();
        }
        catch (AuthenticationException e) {
            if (e instanceof MissingCredentialsException) {
                Logger.printlnMixedYellow("- Remote MBean server", "requires authentication.");
                Logger.statusOk();
            } else {
                Logger.printlnMixedYellow("- Caught unexpected", "AuthenticationException", "during login attempt.");
                Logger.statusUndecided("Vulnerability");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during login attempt");
        }
        catch (Exception e) {
            Logger.printlnMixedYellow("- Caught unexpected", e.getClass().getName(), "during login attempt.");
            Logger.statusUndecided("Vulnerability");
            ExceptionHandler.showStackTrace(e);
        }
        finally {
            Logger.decreaseIndent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enumKaraf() {
        Map<String, Object> env = PluginSystem.getEnv("karaf", "karaf");
        Logger.printlnBlue("Checking for Apache Karaf default credentials:");
        Logger.lineBreak();
        Logger.increaseIndent();
        try {
            MBeanServerConnection conn = PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            Logger.printlnMixedYellow("- Login with default credentials", "karaf:karaf", "was successful.");
            Logger.statusVulnerable();
            this.client = new MBeanServerClient(conn);
            boolean bl = true;
            return bl;
        }
        catch (AuthenticationException e) {
            if (e instanceof WrongCredentialsException) {
                Logger.printlnMixedYellow("- Default credentials", "are not", "in use.");
                Logger.statusOk();
            } else {
                Logger.printlnMixedYellow("- Caught unexpected", "AuthenticationException", "during login attempt.");
                Logger.statusUndecided("Vulnerability");
            }
            ExceptionHandler.showStackTrace(e);
        }
        catch (Exception e) {
            Logger.printlnMixedYellow("- Caught unexpected", e.getClass().getName(), "during login attempt.");
            Logger.statusUndecided("Vulnerability");
            ExceptionHandler.showStackTrace(e);
        }
        finally {
            Logger.decreaseIndent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enumSASL() {
        Map<String, Object> env = PluginSystem.getEnv(null, null);
        Logger.printlnBlue("Checking servers SASL configuration:");
        Logger.lineBreak();
        Logger.increaseIndent();
        boolean sslOrig = BeanshooterOption.CONN_SSL.getBool();
        BeanshooterOption.CONN_SASL.setValue(null);
        for (boolean sslValue : new boolean[]{false, true}) {
            BeanshooterOption.CONN_SSL.setValue(sslValue);
            try {
                MBeanServerConnection conn = PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
                if (sslValue) {
                    Logger.printlnMixedYellow("- Remote JMXMP server uses", "TLS SASL", "profile.");
                    Logger.printMixedBlue("  Login is possible", "without", "credentials when using the ");
                    Logger.printlnPlainMixedYellowFirst("--ssl", "option.");
                } else {
                    Logger.printlnMixedYellow("- Remote JMXMP server", "does not", "use SASL.");
                    Logger.printlnMixedBlue("  Login is possible", "without", "specifying credentials.");
                }
                Logger.statusVulnerable();
                Logger.decreaseIndent();
                this.client = new MBeanServerClient(conn);
                boolean bl = true;
                return bl;
            }
            catch (SaslMissingException e) {
                ExceptionHandler.showStackTrace(e);
            }
            catch (SaslProfileException e) {
                ExceptionHandler.showStackTrace(e);
            }
            catch (Exception e) {
                Logger.printlnMixedYellow("- Caught unexpected", e.getClass().getName(), "during login attempt.");
                Logger.statusUndecided("Vulnerability");
                ExceptionHandler.showStackTrace(e);
                boolean bl = false;
                return bl;
            }
            finally {
                BeanshooterOption.CONN_SSL.setValue(sslOrig);
            }
        }
        env = PluginSystem.getEnv("non existent dummy user", "non existing dummy password");
        SASLMechanism mechanism = SASLMechanism.detectMechanis(this.host, this.port, env);
        if (mechanism != null) {
            Logger.printlnMixedYellow("- Remote JMXMP server uses", mechanism.getProfile(), "SASL profile.");
            if (mechanism == SASLMechanism.DIGEST && mechanism.getExtra() != null) {
                Logger.printlnMixedBlue("  Credentials are requried and the following hostname must be used:", mechanism.getExtra());
            }
            Logger.printMixedBlueFirst("  Notice:", "TLS setting cannot be enumerated and", "--ssl");
            if (BeanshooterOption.CONN_SSL.getBool()) {
                Logger.printlnPlain(" may not be required.");
            } else {
                Logger.printlnPlain(" may be required.");
            }
            Logger.statusOk();
            BeanshooterOption.CONN_SASL.setValue(mechanism.name());
        } else {
            Logger.printlnMixedYellow("- Remote JMXMP server", "probably uses SASL", " but the profile coldn't be enumerated.");
            Logger.statusUndecided("Vulnerability");
        }
        Logger.decreaseIndent();
        return false;
    }

    public void enumSerial() {
        Logger.printlnBlue("Checking pre-auth deserialization behavior:");
        Logger.lineBreak();
        Logger.increaseIndent();
        if (BeanshooterOption.CONN_JMXMP.getBool()) {
            Logger.printlnMixedYellow("- JMXMP serial check is", "work in progress", "but endpoints are usually vulnerable.");
            Logger.statusUndecided("Configuration");
            Logger.decreaseIndent();
            return;
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.credentials", new HashMap());
        try {
            PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            Logger.printlnMixedYellow("- Remote MBeanServer", "accepted", "the payload class.");
            Logger.statusNonDefault();
        }
        catch (InvalidLoginClassException e) {
            Logger.printlnMixedYellow("- Remote MBeanServer", "rejected", "the payload class.");
            Logger.statusOk();
        }
        catch (AuthenticationException e) {
            if (e.getOriginalException() instanceof ClassCastException && e.getMessage().contains("Unsupported type:")) {
                Logger.printlnMixedYellow("- Remote MBeanServer", "rejected", "the payload class (correto).");
                Logger.statusOk();
            } else {
                Logger.printlnMixedYellow("- Remote MBeanServer", "accepted", "the payload class.");
                Logger.statusNonDefault();
            }
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during serial enumeration");
        }
        finally {
            Logger.decreaseIndent();
        }
    }

    public Set<ObjectInstance> enumMBeans() {
        if (this.client == null) {
            return new HashSet<ObjectInstance>();
        }
        Logger.printlnBlue("Checking available MBeans:");
        Logger.lineBreak();
        Logger.increaseIndent();
        Set<ObjectInstance> mbeans = this.client.getMBeans();
        ArgumentHandler arg = ArgumentHandler.getInstance();
        List classNames = mbeans.stream().map(i -> i.getClassName()).collect(Collectors.toList());
        classNames.removeAll(Arrays.asList(arg.getFromConfig("defaultMBeans").split(" ")));
        Logger.printlnMixedYellow("-", String.valueOf(mbeans.size()), "MBeans are currently registred on the MBean server.");
        if (classNames.size() == 0) {
            Logger.printlnMixedBlue("  Found", "0", "non default MBeans.");
        } else {
            Logger.printlnMixedBlue("  Listing", String.valueOf(classNames.size()), "non default MBeans:");
            List<String> interestingMBeans = MBean.getBeanClasses();
            for (ObjectInstance instance : mbeans) {
                if (!classNames.contains(instance.getClassName())) continue;
                if (interestingMBeans.contains(instance.getClassName())) {
                    Logger.printMixedRed("  -", instance.getClassName(), "");
                    Logger.printPlainBlue("(" + instance.getObjectName().toString() + ")");
                    MBean bean = MBean.getMBean(instance.getObjectName());
                    Logger.printlnPlainMixedYellow("", "(action: " + bean.getName() + ")");
                    continue;
                }
                Logger.printMixedYellow("  -", instance.getClassName(), "");
                Logger.printlnPlainBlue("(" + instance.getObjectName().toString() + ")");
            }
        }
        Logger.decreaseIndent();
        return mbeans;
    }

    public boolean requiresLogin() {
        Map<String, Object> env = PluginSystem.getEnv(null, null);
        try {
            PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            return false;
        }
        catch (ApacheKarafException | GlassFishException e) {
            return true;
        }
        catch (AuthenticationException e) {
            if (e instanceof MissingCredentialsException) {
                return true;
            }
            if (e instanceof SaslProfileException) {
                Logger.printlnMixedBlue("Caught", "SaslProfileException", "during login attempt.");
                Logger.printlnMixedYellow("Use the", "--sasl", "option to specify a matching SASL profile.");
                Utils.exit(e);
            }
            Logger.printlnMixedYellow("Caught unknown", e.getOriginalException().getClass().getName(), "during connection attempt.");
            Logger.printlnMixedBlue("Exception message:", e.getOriginalException().getMessage());
            Utils.askToContinue("Treat as credential error and continue?", e);
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during login attempt");
        }
        return true;
    }

    public void checkLoginFormat() {
        Map<String, Object> env = PluginSystem.getEnv("beanshooter", "beanshooter");
        try {
            PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
        }
        catch (AuthenticationException e) {
            if (e instanceof GlassFishException) {
                return;
            }
            if (e instanceof ApacheKarafException) {
                return;
            }
            if (e instanceof WrongCredentialsException) {
                return;
            }
            if (e instanceof MismatchedURIException) {
                Logger.printlnMixedYellow("Caught", "MismatchedURIException", "during login attempt.");
                Logger.printlnMixedBlueFirst("Digest authentication", "requires the correct hostname to be used.");
                Logger.printlnMixedBlue("The following hostname is expected by the server:", ((MismatchedURIException)e).getUri());
                Utils.exit(e);
            }
            if (e instanceof SaslProfileException) {
                Logger.printlnMixedBlue("Caught", "SaslProfileException", "during login attempt.");
                Logger.printlnMixedYellow("Use the", "--sasl", "option to specify a matching SASL profile.");
                Utils.exit(e);
            }
            Logger.printlnMixedYellow("Caught unknown", e.getOriginalException().getClass().getName(), "during login attempt.");
            Logger.printlnMixedBlue("Exception message:", e.getOriginalException().getMessage());
            Utils.askToContinue("Treat as credential error and continue?", e);
        }
        catch (J4pRemoteException e) {
            ExceptionHandler.handleJ4pRemoteException(e, "during login attempt");
        }
    }

    public void enumJolokiaVersion() {
        if (this.client == null) {
            return;
        }
        MBeanServerConnection conn = this.client.getConnection();
        if (!(conn instanceof RemoteJmxAdapter)) {
            return;
        }
        String agentVersion = "unknown";
        String protocolVersion = "unknown";
        try {
            Field agentVersionField = RemoteJmxAdapter.class.getDeclaredField("agentVersion");
            Field protocolVersionField = RemoteJmxAdapter.class.getDeclaredField("protocolVersion");
            agentVersionField.setAccessible(true);
            protocolVersionField.setAccessible(true);
            agentVersion = (String)agentVersionField.get(conn);
            protocolVersion = (String)protocolVersionField.get(conn);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return;
        }
        Logger.printlnBlue("Checking Jolokia Version:");
        Logger.lineBreak();
        Logger.increaseIndent();
        Logger.printMixedYellow("- Agent Version", agentVersion, "- Protocol Version: ");
        Logger.printlnPlainYellow(protocolVersion);
        DefaultArtifactVersion targetVersion = new DefaultArtifactVersion(agentVersion);
        DefaultArtifactVersion vulnerableVersion = new DefaultArtifactVersion("1.6.1");
        if (targetVersion.compareTo(vulnerableVersion) < 0) {
            Logger.printlnMixedBlue("There are", "known security vulnerabilities", "for this version of Jolokia.");
            Logger.statusVulnerable();
        } else {
            Logger.statusOk();
        }
        Logger.decreaseIndent();
    }

    public void enumJolokiaProxy() {
        if (BeanshooterOption.CONN_JOLOKIA_PROXY.notNull()) {
            return;
        }
        BeanshooterOption.CONN_JOLOKIA_PROXY.setValue("INVALID-JMX-URL");
        Map<String, Object> env = ArgumentHandler.getEnv();
        Logger.printlnBlue("Checking whether Jolokia Proxy Mode is enabled:");
        Logger.lineBreak();
        Logger.increaseIndent();
        try {
            PluginSystem.getMBeanServerConnectionUmanaged(this.host, this.port, env);
            ExceptionHandler.internalError("enumJolokiaProxy", "No Exception encountered despite one was expected.");
        }
        catch (AuthenticationException e) {
            ExceptionHandler.internalError("enumJolokiaProxy", "Caught unexpected AuthenticationException");
        }
        catch (J4pRemoteException e) {
            if (e.getMessage().contains("No JSR-160 proxy is enabled")) {
                Logger.printlnMixedYellow("- Jolokia Proxy Mode", "is disabled.", "JMX forwarding not possible.");
                Logger.statusOk();
            } else if (e.getMessage().contains("java.net.MalformedURLException")) {
                Logger.printlnMixedYellow("- Jolokia Proxy Mode", "is enabled!", "You may connect to backend JMX services.");
                Logger.statusVulnerable();
            } else {
                ExceptionHandler.unexpectedException(e, "while enumerating", "Jolokia proxy mode", true);
            }
        }
        finally {
            Logger.decreaseIndent();
            BeanshooterOption.CONN_JOLOKIA_PROXY.setValue(null);
        }
    }
}

