/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin.providers;

import de.qtc.beanshooter.cli.ArgumentHandler;
import de.qtc.beanshooter.exceptions.ApacheKarafException;
import de.qtc.beanshooter.exceptions.AuthenticationException;
import de.qtc.beanshooter.exceptions.ExceptionHandler;
import de.qtc.beanshooter.exceptions.GlassFishException;
import de.qtc.beanshooter.exceptions.InvalidLoginClassException;
import de.qtc.beanshooter.exceptions.LoginClassCastException;
import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.networking.RMIEndpoint;
import de.qtc.beanshooter.networking.RMIRegistryEndpoint;
import de.qtc.beanshooter.operation.BeanshooterOperation;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.IMBeanServerProvider;
import de.qtc.beanshooter.utils.Utils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.SocketException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.security.cert.CertPathValidatorException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.callback.UnsupportedCallbackException;

public class RMIProvider
implements IMBeanServerProvider {
    @Override
    public MBeanServerConnection getMBeanServerConnection(String host, int port, Map<String, Object> env) throws AuthenticationException {
        Throwable t;
        RMIRegistryEndpoint regEndpoint = new RMIRegistryEndpoint(host, port);
        RMIServer rmiServer = null;
        RMIConnector rmiConnector = null;
        MBeanServerConnection connection = null;
        if (BeanshooterOption.TARGET_OBJID_CONNECTION.notNull()) {
            ObjID objID = Utils.parseObjID((String)BeanshooterOption.TARGET_OBJID_CONNECTION.getValue());
            RMIConnection conn = this.getRMIConnectionByObjID(regEndpoint, objID);
            rmiServer = new FakeRMIServer(conn);
        } else {
            rmiServer = this.getRMIServer(regEndpoint);
        }
        rmiConnector = new RMIConnector(rmiServer, env);
        try {
            rmiConnector.connect();
            connection = rmiConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            t = ExceptionHandler.getCause(e);
            if (t instanceof InvalidClassException) {
                throw new InvalidLoginClassException(e);
            }
            if (t instanceof ClassNotFoundException) {
                throw new InvalidLoginClassException(e);
            }
            if (t instanceof ConnectIOException) {
                ExceptionHandler.connectIOException(e, "newclient");
            } else {
                if (t instanceof NotSerializableException && t.getMessage().contains("PrincipalCallback")) {
                    throw new GlassFishException(e);
                }
                if (t instanceof UnsupportedCallbackException) {
                    ExceptionHandler.unsupportedCallback((Exception)t);
                }
            }
            Logger.resetIndent();
            Logger.eprintlnMixedYellow("Caught", t.getClass().getName(), "while invoking the newClient method.");
            if (t instanceof NoSuchObjectException) {
                Logger.eprintlnMixedBlue("You probably specified an", "ObjID value", "that does not exist on the server.");
            } else if (t instanceof ConnectException) {
                if (t.getMessage().contains("Connection refused")) {
                    Logger.eprintlnMixedBlue("The JMX remote object", "refused", "the connection.");
                } else if (t.getMessage().contains("Network is unreachable")) {
                    Logger.eprintlnMixedBlue("The JMX remote object is", "unreachable.");
                } else {
                    ExceptionHandler.unknownReason(e);
                }
                if (BeanshooterOption.TARGET_OBJID_CONNECTION.isNull()) {
                    Logger.eprintlnMixedYellow("The JMX", "bound name", "within the RMI registry is probably pointing to an invalid server.");
                }
            } else if (t instanceof EOFException || t instanceof SocketException) {
                Logger.eprintln("The JMX server closed the connection. This usually indicates a networking problem.");
            } else if (ArgumentHandler.getInstance().getAction() == BeanshooterOperation.SERIAL && BeanshooterOption.SERIAL_PREAUTH.getBool()) {
                Logger.eprintlnMixedBlue("This exception could be caused by the selected gadget and the deserialization attack may", "worked anyway.");
                if (!BeanshooterOption.GLOBAL_STACK_TRACE.getBool()) {
                    Logger.eprintlnMixedYellow("If it did not work you may want to rerun with the", "--stack-trace", "option to further investigate.");
                }
            } else if (t instanceof CertPathValidatorException) {
                Logger.eprintlnMixedBlue("The server probably uses TLS settings that are", "incompatible", "with your current security settings.");
                Logger.eprintlnMixedYellow("You may try to edit your", "java.security", "policy file to overcome the issue.");
                Utils.exit(e);
            } else {
                ExceptionHandler.unknownReason(e);
            }
            Utils.exit(e);
        }
        catch (SecurityException e) {
            ExceptionHandler.handleSecurityException(e);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Expected String[2]")) {
                throw new ApacheKarafException(e);
            }
            throw e;
        }
        catch (Exception e) {
            t = ExceptionHandler.getCause(e);
            if (t instanceof ClassCastException) {
                throw new LoginClassCastException(e);
            }
            throw e;
        }
        return connection;
    }

    private RMIConnection getRMIConnectionByObjID(RMIEndpoint endpoint, ObjID objID) {
        RemoteRef ref = endpoint.getRemoteRef(objID);
        RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(ref);
        return (RMIConnection)Proxy.newProxyInstance(RMIProvider.class.getClassLoader(), new Class[]{RMIConnection.class}, (InvocationHandler)handler);
    }

    public RMIServer getRMIServer(RMIRegistryEndpoint regEndpoint) {
        if (BeanshooterOption.TARGET_OBJID_SERVER.notNull()) {
            ObjID objID = Utils.parseObjID((String)BeanshooterOption.TARGET_OBJID_SERVER.getValue());
            return this.getRMIServerByObjID(regEndpoint, objID);
        }
        return this.getRMIServerByLookup(regEndpoint);
    }

    private RMIServer getRMIServerByObjID(RMIEndpoint endpoint, ObjID objID) {
        RemoteRef ref = endpoint.getRemoteRef(objID);
        RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(ref);
        return (RMIServer)Proxy.newProxyInstance(RMIProvider.class.getClassLoader(), new Class[]{RMIServer.class}, (InvocationHandler)handler);
    }

    private RMIServer getRMIServerByLookup(RMIRegistryEndpoint regEndpoint, String boundName) {
        RMIServer returnValue = null;
        try {
            returnValue = (RMIServer)regEndpoint.lookup(boundName);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.lookupClassNotFoundException(e, e.getMessage());
        }
        catch (ClassCastException e) {
            Logger.printlnMixedYellow("Unable to cast remote object to", "RMIServer", "class.");
            Logger.printlnMixedBlue("You probbably specified a bound name that does not implement the", "RMIServer", "interface.");
            Utils.exit(e);
        }
        return returnValue;
    }

    private RMIServer getRMIServerByLookup(RMIRegistryEndpoint regEndpoint) {
        String[] boundNames;
        if (BeanshooterOption.TARGET_BOUND_NAME.notNull()) {
            return this.getRMIServerByLookup(regEndpoint, (String)BeanshooterOption.TARGET_BOUND_NAME.getValue());
        }
        HashMap<String, Remote> mappings = new HashMap<String, Remote>();
        for (String boundName : boundNames = regEndpoint.getBoundNames()) {
            try {
                Remote remote = regEndpoint.lookup(boundName);
                mappings.put(boundName, remote);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Map<String, Remote> jmxMap = Utils.filterJmxEndpoints(mappings);
        int jmxEndpoints = jmxMap.size();
        if (jmxEndpoints == 0) {
            Logger.printlnMixedYellow("The specified RMI registry", "does not", "contain any JMX objects.");
            Utils.exit();
        }
        String selected = (String)jmxMap.keySet().toArray()[0];
        Remote selectedRemote = jmxMap.get(selected);
        if (jmxEndpoints > 1) {
            Logger.printlnMixedYellow("RMI registry contains", "more than one", "JMX instance.");
            Logger.printlnMixedBlue("The bound name", selected, "is used for the operation.");
            Logger.printlnMixedYellow("Use the", "--bound-name", "option to select a different one.");
            Logger.lineBreak();
        }
        return (RMIServer)selectedRemote;
    }

    private class FakeRMIServer
    implements RMIServer {
        private final RMIConnection conn;

        public FakeRMIServer(RMIConnection conn) {
            this.conn = conn;
        }

        @Override
        public String getVersion() throws RemoteException {
            return "1.0";
        }

        @Override
        public RMIConnection newClient(Object credentials) throws IOException {
            return this.conn;
        }
    }
}

