/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin.providers;

import de.qtc.beanshooter.io.Logger;
import de.qtc.beanshooter.plugin.IResponseHandler;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ResponseHandlerProvider
implements IResponseHandler {
    @Override
    public void handleResponse(Object responseObject) {
        Class<?> responseClass = responseObject.getClass();
        if (responseObject instanceof Collection) {
            this.handleCollection(responseObject);
        } else if (responseObject instanceof Map) {
            this.handleMap(responseObject);
        } else if (responseClass.isArray()) {
            this.handleArray(responseObject);
        } else if (responseObject instanceof File) {
            this.handleFile((File)responseObject);
        } else if (responseObject instanceof Byte) {
            this.handleByte((Byte)responseObject);
        } else {
            this.handleDefault(responseObject);
        }
    }

    public void handleCollection(Object o) {
        for (Object item : (Collection)o) {
            this.handleResponse(item);
        }
    }

    public void handleMap(Object o) {
        Map map = (Map)o;
        for (Map.Entry item : map.entrySet()) {
            this.handleResponse(item.getKey());
            System.out.print("  --> ");
            this.handleResponse(item.getValue());
        }
    }

    public void handleArray(Object o) {
        Object[] objectArray = null;
        Class<?> type = o.getClass().getComponentType();
        if (type.isPrimitive()) {
            int length = Array.getLength(o);
            objectArray = new Object[length];
            for (int ctr = 0; ctr < length; ++ctr) {
                objectArray[ctr] = Array.get(o, ctr);
            }
        } else {
            objectArray = (Object[])o;
        }
        for (Object item : objectArray) {
            this.handleResponse(item);
        }
    }

    public void handleFile(File o) {
        Logger.printlnPlain(o.getAbsolutePath());
    }

    public void handleByte(byte o) {
        Logger.printPlain(String.format("%02x", o));
    }

    public void handleDefault(Object o) {
        Logger.printlnPlain(o.toString());
    }
}

