/*
 * Decompiled with CFR 0.152.
 */
package de.qtc.beanshooter.plugin.providers;

import de.qtc.beanshooter.networking.LoopbackSocketFactory;
import de.qtc.beanshooter.networking.LoopbackSslSocketFactory;
import de.qtc.beanshooter.networking.TrustAllSocketFactory;
import de.qtc.beanshooter.operation.BeanshooterOption;
import de.qtc.beanshooter.plugin.ISocketFactoryProvider;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import javax.net.SocketFactory;

public class SocketFactoryProvider
implements ISocketFactoryProvider {
    @Override
    public RMIClientSocketFactory getRMIClientSocketFactory(String host, int port) {
        if (BeanshooterOption.CONN_SSL.getBool()) {
            return new TrustAllSocketFactory();
        }
        return RMISocketFactory.getDefaultSocketFactory();
    }

    @Override
    public RMISocketFactory getDefaultRMISocketFactory(String host, int port) {
        RMISocketFactory fac = RMISocketFactory.getDefaultSocketFactory();
        return new LoopbackSocketFactory(host, fac, BeanshooterOption.CONN_FOLLOW.getBool());
    }

    @Override
    public String getDefaultSSLSocketFactoryClass(String host, int port) {
        TrustAllSocketFactory trustAllFax = new TrustAllSocketFactory();
        LoopbackSslSocketFactory.host = host;
        LoopbackSslSocketFactory.fac = trustAllFax.getSSLSocketFactory();
        LoopbackSslSocketFactory.followRedirect = BeanshooterOption.CONN_FOLLOW.getBool();
        return "de.qtc.beanshooter.networking.LoopbackSslSocketFactory";
    }

    @Override
    public SocketFactory getSSLSocketFactory(String host, int port) {
        return new TrustAllSocketFactory().getSSLSocketFactory();
    }
}

