/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.osgi.services.ProxyConfiguration;

final class OSGiCredentialsProvider
implements CredentialsProvider {
    private static final Log log = LogFactory.getLog(OSGiCredentialsProvider.class);
    private static final int HOST_AND_PORT_MATCH = 12;
    private static final String BASIC_SCHEME_NAME = "BASIC";
    private static final String NTLM_SCHEME_NAME = "NTLM";
    private final List<ProxyConfiguration> proxyConfigurations;

    OSGiCredentialsProvider(List<ProxyConfiguration> proxyConfigurations) {
        this.proxyConfigurations = proxyConfigurations;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        for (ProxyConfiguration config : this.proxyConfigurations) {
            if (!config.isEnabled() || !this.isSuitable(config, authScope)) continue;
            String scheme = authScope.getScheme();
            if (BASIC_SCHEME_NAME.equals(scheme)) {
                return new UsernamePasswordCredentials(config.getUsername(), config.getPassword());
            }
            if (NTLM_SCHEME_NAME.equals(scheme)) {
                return OSGiCredentialsProvider.createNTCredentials(config);
            }
            log.debug("credentials requested for unsupported authentication scheme " + scheme);
        }
        return null;
    }

    @Override
    public void clear() {
    }

    private boolean isSuitable(ProxyConfiguration config, AuthScope authScope) {
        return authScope.match(new AuthScope(config.getHostname(), config.getPort())) >= 12;
    }

    private static Credentials createNTCredentials(ProxyConfiguration config) {
        String domain;
        String username;
        String domainAndUsername = config.getUsername();
        int index = domainAndUsername.indexOf("\\");
        if (index > -1) {
            username = domainAndUsername.substring(index + 1);
            domain = domainAndUsername.substring(0, index);
        } else {
            username = domainAndUsername;
            domain = null;
        }
        return new NTCredentials(username, config.getPassword(), null, domain);
    }
}

